/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.upload.table;

import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import org.jdesktop.application.Resource;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationModuleEvent;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.decorators.ProgressBarDecorator;
import org.limewire.ui.swing.transfer.TransferTable;
import org.limewire.ui.swing.upload.UploadMediator;
import org.limewire.ui.swing.upload.table.UploadActionHandler;
import org.limewire.ui.swing.upload.table.UploadActionRendererEditor;
import org.limewire.ui.swing.upload.table.UploadCancelRendererEditor;
import org.limewire.ui.swing.upload.table.UploadMessageRenderer;
import org.limewire.ui.swing.upload.table.UploadPopupHandler;
import org.limewire.ui.swing.upload.table.UploadPopupMenuFactory;
import org.limewire.ui.swing.upload.table.UploadProgressRenderer;
import org.limewire.ui.swing.upload.table.UploadTableFormat;
import org.limewire.ui.swing.upload.table.UploadTitleRenderer;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.GuiUtils;

public class UploadTable
extends TransferTable<UploadItem> {
    @Resource
    private int rowHeight;
    @Resource
    private int gapMinWidth;
    @Resource
    private int gapPrefWidth;
    @Resource
    private int gapMaxWidth;
    @Resource
    private int titleMinWidth;
    @Resource
    private int titlePrefWidth;
    @Resource
    private int titleMaxWidth;
    @Resource
    private int progressMinWidth;
    @Resource
    private int progressPrefWidth;
    @Resource
    private int progressMaxWidth;
    @Resource
    private int messageMinWidth;
    @Resource
    private int messagePrefWidth;
    @Resource
    private int messageMaxWidth;
    @Resource
    private int actionMinWidth;
    @Resource
    private int actionPrefWidth;
    @Resource
    private int actionMaxWidth;
    @Resource
    private int cancelMinWidth;
    @Resource
    private int cancelPrefWidth;
    @Resource
    private int cancelMaxWidth;
    private final CategoryIconManager iconManager;
    private final UploadActionHandler uploadActionHandler;
    private final DefaultEventSelectionModel<UploadItem> selectionModel;
    private final UploadProgressRenderer uploadProgressRenderer;
    private boolean isPro = false;

    @Inject
    public UploadTable(@Assisted UploadMediator uploadMediator, LibraryManager libraryManager, CategoryIconManager iconManager, ProgressBarDecorator progressBarDecorator, UploadPopupMenuFactory popupMenuFactory, UploadActionHandler uploadActionHandler) {
        super(uploadMediator.getUploadList(), new UploadTableFormat());
        this.iconManager = iconManager;
        this.uploadActionHandler = uploadActionHandler;
        this.uploadProgressRenderer = new UploadProgressRenderer(progressBarDecorator);
        GuiUtils.assignResources(this);
        this.selectionModel = new DefaultEventSelectionModel<UploadItem>(uploadMediator.getUploadList());
        this.selectionModel.setSelectionMode(103);
        this.setSelectionModel(this.selectionModel);
        this.setRowHeight(this.rowHeight);
        this.setPopupHandler(new UploadPopupHandler(this, popupMenuFactory));
        this.setEnterKeyAction(new LaunchAction());
        this.initializeColumns();
        this.initializeRenderers();
    }

    @Inject
    public void register(final ActivationManager activationManager) {
        this.isPro = activationManager.isProActive();
        activationManager.addModuleListener(new EventListener<ActivationModuleEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(ActivationModuleEvent event) {
                if (UploadTable.this.isPro != activationManager.isProActive()) {
                    UploadTable.this.isPro = activationManager.isProActive();
                    UploadTable.this.uploadProgressRenderer.updateColor();
                }
            }
        });
    }

    private void initializeColumns() {
        this.setColumnWidths(0, this.titleMinWidth, this.titlePrefWidth, this.titleMaxWidth);
        this.setColumnWidths(1, this.gapMinWidth, this.gapPrefWidth, this.gapMaxWidth);
        this.setColumnWidths(2, this.progressMinWidth, this.progressPrefWidth, this.progressMaxWidth);
        this.setColumnWidths(3, this.gapMinWidth, this.gapPrefWidth, this.gapMaxWidth);
        this.setColumnWidths(4, this.messageMinWidth, this.messagePrefWidth, this.messageMaxWidth);
        this.setColumnWidths(5, this.gapMinWidth, this.gapPrefWidth, this.gapMaxWidth);
        this.setColumnWidths(6, this.actionMinWidth, this.actionPrefWidth, this.actionMaxWidth);
        this.setColumnWidths(7, this.gapMinWidth, this.gapPrefWidth, this.gapMaxWidth);
        this.setColumnWidths(8, this.cancelMinWidth, this.cancelPrefWidth, this.cancelMaxWidth);
    }

    private void initializeRenderers() {
        this.setColumnRenderer(0, new UploadTitleRenderer(this.iconManager));
        this.setColumnRenderer(4, new UploadMessageRenderer());
        this.setColumnRenderer(2, this.uploadProgressRenderer);
        this.setColumnRenderer(6, new UploadActionRendererEditor(null));
        this.setColumnRenderer(8, new UploadCancelRendererEditor(null));
        TransferTable.GapRenderer gapRenderer = new TransferTable.GapRenderer();
        this.setColumnRenderer(1, gapRenderer);
        this.setColumnRenderer(3, gapRenderer);
        this.setColumnRenderer(5, gapRenderer);
        this.setColumnRenderer(7, gapRenderer);
        this.setColumnEditor(6, new UploadActionRendererEditor(this.uploadActionHandler));
        this.setColumnEditor(8, new UploadCancelRendererEditor(this.uploadActionHandler));
    }

    public List<UploadItem> getSelectedItems() {
        return Collections.unmodifiableList(this.selectionModel.getSelected());
    }

    public UploadItem getUploadItem(int row) {
        return (UploadItem)this.getElementAt(row);
    }

    private class LaunchAction
    extends AbstractAction {
        private LaunchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UploadItem item;
            List<UploadItem> selectedItems = UploadTable.this.getSelectedItems();
            if (selectedItems.size() == 1 && (item = selectedItems.get(0)).getUploadItemType() == UploadItem.UploadItemType.GNUTELLA && !UploadMediator.isBrowseHost(item)) {
                UploadTable.this.uploadActionHandler.performAction("launch", item);
            }
        }
    }
}

