/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.transfer;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXPanel;
import org.limewire.ui.swing.components.LimeProgressBar;
import org.limewire.ui.swing.components.decorators.ProgressBarDecorator;
import org.limewire.ui.swing.transfer.TransferRendererResources;

public class TransferProgressRenderer
extends JXPanel
implements TableCellRenderer {
    protected final TransferRendererResources resources;
    private final ProgressBarDecorator progressBarDecorator;
    protected final LimeProgressBar progressBar;
    protected final JLabel timeLabel;

    public TransferProgressRenderer(ProgressBarDecorator progressBarDecorator) {
        super(new MigLayout("insets 0, gap 0, novisualpadding, nogrid, aligny center"));
        this.progressBarDecorator = progressBarDecorator;
        this.resources = new TransferRendererResources();
        this.progressBar = new LimeProgressBar(0, 100);
        this.updateColor();
        this.progressBar.setBorder(new LineBorder(this.resources.getProgressBarBorderColor()));
        Dimension size = new Dimension(this.resources.getProgressBarWidth(), this.resources.getProgressBarHeight());
        this.progressBar.setMaximumSize(size);
        this.progressBar.setPreferredSize(size);
        this.timeLabel = new JLabel();
        this.resources.decorateComponent(this.timeLabel);
        this.add(this.progressBar);
        this.add(this.timeLabel);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int columnWidth = table.getColumnModel().getColumn(column).getWidth();
        this.updateProgress(value, columnWidth);
        this.updateTime(value);
        return this;
    }

    protected void updateProgress(Object value, int columnWidth) {
        this.progressBar.setValue(0);
        this.progressBar.setVisible(true);
    }

    public void updateColor() {
        this.progressBarDecorator.decoratePlain(this.progressBar);
    }

    protected void updateTime(Object value) {
        this.timeLabel.setVisible(false);
    }
}

