/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.limewire.ui.swing.table.StripedJXTable;
import org.limewire.ui.swing.table.TableCellHeaderRenderer;
import org.limewire.ui.swing.table.TableColors;
import org.limewire.ui.swing.table.TableColumnDoubleClickHandler;
import org.limewire.ui.swing.table.TableDoubleClickHandler;
import org.limewire.ui.swing.table.TablePopupHandler;
import org.limewire.ui.swing.util.PropertyUtils;

public class MouseableTable
extends StripedJXTable {
    private TablePopupHandler popupHandler;
    private TableDoubleClickHandler rowDoubleClickHandler;
    private TableColumnDoubleClickHandler columnDoubleClickHandler;
    private TableColors colors = this.newTableColors();
    private TableCellHeaderRenderer defaultRenderer;
    protected MouseMotionListener mouseOverEditorListener;

    public MouseableTable() {
        this.initialize();
    }

    protected TableColors newTableColors() {
        return new TableColors();
    }

    public TableColors getTableColors() {
        return this.colors;
    }

    public MouseableTable(TableModel model) {
        super(model);
        this.initialize();
    }

    public void setPopupHandler(TablePopupHandler popupHandler) {
        this.popupHandler = popupHandler;
    }

    public void setDoubleClickHandler(TableDoubleClickHandler tableDoubleClickHandler) {
        this.rowDoubleClickHandler = tableDoubleClickHandler;
    }

    public void setColumnDoubleClickHandler(TableColumnDoubleClickHandler columnDoubleClickHandler) {
        this.columnDoubleClickHandler = columnDoubleClickHandler;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int row = this.rowAtPoint(event.getPoint());
        int col = this.columnAtPoint(event.getPoint());
        if (row > -1 && col > -1) {
            return this.getToolTipText(row, col);
        }
        return null;
    }

    protected String getToolTipText(int row, int col) {
        Object value = this.getValueAt(row, col);
        JComponent renderer = this.getRendererComponent(row, col, value);
        if (value != null && this.isClipped(renderer, col)) {
            String toolTip = renderer.getToolTipText();
            if (toolTip != null) {
                return toolTip;
            }
            if (renderer instanceof JLabel) {
                return ((JLabel)renderer).getText();
            }
            return PropertyUtils.getToolTipText(value);
        }
        return null;
    }

    private boolean isClipped(JComponent renderer, int col) {
        return renderer.getPreferredSize().width > this.getColumnModel().getColumn(col).getWidth();
    }

    private JComponent getRendererComponent(int row, int col, Object value) {
        TableCellRenderer tcr = this.getCellRenderer(row, col);
        return (JComponent)tcr.getTableCellRendererComponent(this, value, false, false, row, col);
    }

    protected void initialize() {
        this.setSelectionMode(2);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setTableHeaderRenderer();
        this.setAutoResizeMode(1);
        this.setFont(this.colors.getTableFont());
        this.setHighlighters(this.colors.getEvenHighlighter(), this.colors.getOddHighlighter(), new ColorHighlighter(new MenuHighlightPredicate(this), this.colors.menuRowColor, this.colors.menuRowForeground, this.colors.menuRowColor, this.colors.menuRowForeground));
        this.setGridColor(this.colors.getGridColor());
        this.mouseOverEditorListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int col;
                int row = MouseableTable.this.rowAtPoint(e.getPoint());
                if (MouseableTable.this.isCellEditable(row, col = MouseableTable.this.columnAtPoint(e.getPoint())) && (row != MouseableTable.this.getEditingRow() || col != MouseableTable.this.getEditingColumn())) {
                    MouseableTable.this.editCellAt(row, col);
                } else {
                    MouseableTable.this.maybeCancelEditing();
                }
            }
        };
        this.addMouseMotionListener(this.mouseOverEditorListener);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col = MouseableTable.this.columnAtPoint(e.getPoint());
                int row = MouseableTable.this.rowAtPoint(e.getPoint());
                if (row >= 0 && col >= 0 && (MouseableTable.this.rowDoubleClickHandler != null || MouseableTable.this.columnDoubleClickHandler != null)) {
                    Component component = e.getComponent();
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && !(component.getComponentAt(e.getPoint()) instanceof JButton)) {
                        if (MouseableTable.this.rowDoubleClickHandler != null) {
                            MouseableTable.this.rowDoubleClickHandler.handleDoubleClick(row);
                        }
                        if (MouseableTable.this.columnDoubleClickHandler != null) {
                            MouseableTable.this.columnDoubleClickHandler.handleDoubleClick(col);
                        }
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MouseableTable.this.maybeCancelEditing();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TableCellEditor editor;
                int col = MouseableTable.this.columnAtPoint(e.getPoint());
                int row = MouseableTable.this.rowAtPoint(e.getPoint());
                if (MouseableTable.this.isEditing() && MouseableTable.this.isCellEditable(row, col) && (editor = MouseableTable.this.getCellEditor(row, col)) != null) {
                    MouseableTable.this.prepareEditor(editor, row, col);
                }
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger() && MouseableTable.this.popupHandler != null) {
                    int col = MouseableTable.this.columnAtPoint(e.getPoint());
                    int row = MouseableTable.this.rowAtPoint(e.getPoint());
                    if (row >= 0 && col >= 0) {
                        MouseableTable.this.popupHandler.maybeShowPopup(e.getComponent(), e.getX(), e.getY());
                        TableCellEditor editor = MouseableTable.this.getCellEditor();
                        if (editor != null) {
                            editor.cancelCellEditing();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            this.removeEditor();
        }
    }

    public void setStripeHighlighterEnabled(boolean striped) {
        if (striped) {
            this.setHighlighters(this.colors.getEvenHighlighter(), this.colors.getOddHighlighter());
        } else {
            this.setHighlighters(new ColorHighlighter(HighlightPredicate.EVEN, this.colors.evenColor, this.colors.evenForeground, this.colors.evenColor, this.colors.evenForeground), new ColorHighlighter(HighlightPredicate.ODD, this.colors.evenColor, this.colors.evenForeground, this.colors.evenColor, this.colors.evenForeground), new ColorHighlighter(new MenuHighlightPredicate(this), this.colors.menuRowColor, this.colors.menuRowForeground, this.colors.menuRowColor, this.colors.menuRowForeground));
        }
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component comp = super.prepareEditor(editor, row, column);
        if (this.compoundHighlighter != null) {
            ComponentAdapter adapter = this.getComponentAdapter(row, column);
            comp = this.compoundHighlighter.highlight(comp, adapter);
        }
        return comp;
    }

    protected void setTableHeaderRenderer() {
        JTableHeader th = this.getTableHeader();
        th.setDefaultRenderer(this.getTableCellHeaderRenderer());
    }

    private TableCellRenderer getTableCellHeaderRenderer() {
        if (this.defaultRenderer == null) {
            this.defaultRenderer = new TableCellHeaderRenderer();
        }
        return this.defaultRenderer;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            JTableHeader th = new JTableHeader();
            th.setDefaultRenderer(this.getTableCellHeaderRenderer());
            Component renderer = th.getDefaultRenderer().getTableCellRendererComponent(null, "", false, false, -1, -1);
            JPanel cornerComponent = new JPanel(new BorderLayout());
            cornerComponent.add(renderer, "Center");
            scrollPane.setCorner("UPPER_RIGHT_CORNER", cornerComponent);
        }
    }

    public boolean isMenuShowing(int row) {
        if (this.popupHandler != null) {
            return this.popupHandler.isPopupShowing(row);
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row >= this.getRowCount() || col >= this.getColumnCount() || row < 0 || col < 0) {
            return false;
        }
        return this.getColumnModel().getColumn(col).getCellEditor() != null;
    }

    public void setDefaultEditor(Class clazz, TableCellEditor editor) {
        boolean usesEventTableModel = this.getModel() instanceof DefaultEventTableModel;
        boolean usesAdvancedTableFormat = false;
        TableFormat tableFormat = null;
        if (usesEventTableModel) {
            tableFormat = ((DefaultEventTableModel)this.getModel()).getTableFormat();
            usesAdvancedTableFormat = tableFormat instanceof AdvancedTableFormat;
        }
        if (usesEventTableModel && usesAdvancedTableFormat) {
            AdvancedTableFormat format = (AdvancedTableFormat)tableFormat;
            for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
                Class columnClass = format.getColumnClass(i);
                if (columnClass != clazz) continue;
                this.getColumnModel().getColumn(i).setCellEditor(editor);
            }
        } else {
            super.setDefaultEditor(clazz, editor);
        }
    }

    public void setDefaultRenderer(Class clazz, TableCellRenderer renderer) {
        boolean usesEventTableModel = this.getModel() instanceof DefaultEventTableModel;
        boolean usesAdvancedTableFormat = false;
        TableFormat tableFormat = null;
        if (usesEventTableModel) {
            tableFormat = ((DefaultEventTableModel)this.getModel()).getTableFormat();
            usesAdvancedTableFormat = tableFormat instanceof AdvancedTableFormat;
        }
        if (usesEventTableModel && usesAdvancedTableFormat) {
            AdvancedTableFormat format = (AdvancedTableFormat)tableFormat;
            for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
                Class columnClass = format.getColumnClass(i);
                if (columnClass != clazz) continue;
                this.getColumnModel().getColumn(i).setCellRenderer(renderer);
                break;
            }
        } else {
            super.setDefaultRenderer(clazz, renderer);
        }
    }

    public void ensureRowVisible(int row) {
        if (row != -1) {
            Rectangle cellRect = this.getCellRect(row, 0, false);
            Rectangle visibleRect = this.getVisibleRect();
            if (!visibleRect.intersects(cellRect)) {
                this.scrollRectToVisible(cellRect);
            }
        }
    }

    public boolean isColumnVisible(int column) {
        Rectangle cellRect = this.getCellRect(0, column, false);
        Rectangle visibleRect = this.getVisibleRect();
        return visibleRect.intersects(cellRect);
    }

    private void maybeCancelEditing() {
        Point mousePosition = this.getMousePosition();
        if (this.getCellEditor() != null && (mousePosition == null || this.rowAtPoint(mousePosition) == -1 || this.columnAtPoint(mousePosition) == -1)) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    private static class MenuHighlightPredicate
    implements HighlightPredicate {
        private MouseableTable table;

        public MenuHighlightPredicate(MouseableTable table) {
            this.table = table;
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            if (!adapter.getComponent().isEnabled()) {
                return false;
            }
            return this.table.isMenuShowing(adapter.row);
        }
    }
}

