/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.shell;

import java.io.IOException;
import org.limewire.ui.swing.shell.WindowsAssociation;
import org.limewire.util.SystemUtils;

public class WindowsMagnetHandlerAssociation
extends WindowsAssociation {
    private static final String HKCU = "HKEY_CURRENT_USER";
    private static final String HANDLER = "SOFTWARE\\Magnet\\Handlers\\";
    private final String program;

    public WindowsMagnetHandlerAssociation(String program, String executable) {
        super(executable);
        this.program = program;
    }

    @Override
    protected String get() throws IOException {
        return WindowsMagnetHandlerAssociation.parsePath(SystemUtils.registryReadText(HKCU, HANDLER + this.program, "ShellExecute"));
    }

    @Override
    public void register() {
        SystemUtils.registryWriteText(HKCU, HANDLER + this.program, "", this.program);
        SystemUtils.registryWriteText(HKCU, HANDLER + this.program, "DefaultIcon", "\"" + this.executable + "\",0");
        SystemUtils.registryWriteText(HKCU, HANDLER + this.program, "Description", this.program);
        SystemUtils.registryWriteNumber(HKCU, HANDLER + this.program, "kt", 0);
        SystemUtils.registryWriteText(HKCU, HANDLER + this.program, "ShellExecute", "\"" + this.executable + "\" \"%URL\"");
        SystemUtils.registryWriteNumber(HKCU, HANDLER + this.program + "\\Type", "urn:sha1", 0);
    }

    @Override
    public boolean canUnregister() {
        return true;
    }

    @Override
    public void unregister() {
        SystemUtils.registryDelete(HKCU, HANDLER + this.program);
    }
}

