/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel.list;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.Objects;

class SearchHighlightUtil {
    private static final Log LOG = LogFactory.getLog(SearchHighlightUtil.class);
    private final StringBuilder builderBuffer = new StringBuilder();
    private final Matcher matcher;

    SearchHighlightUtil(String search) {
        String literalSearch = SearchHighlightUtil.createLiteralSearch(Objects.nonNull(search, "search"));
        Pattern pattern = Pattern.compile("\\b(" + literalSearch + ")", 2);
        this.matcher = pattern.matcher("");
    }

    public String highlight(String content) {
        if (content == null) {
            return "";
        }
        this.matcher.reset(content);
        this.builderBuffer.setLength(0);
        int index = 0;
        while (this.matcher.find()) {
            int startIndex = this.matcher.start();
            this.builderBuffer.append(content.substring(index, startIndex));
            String word = this.matcher.group();
            this.builderBuffer.append("<b>").append(word).append("</b>");
            index = this.matcher.end();
            LOG.debugf("Start: {0} url: {1} end: {2}", (Object)startIndex, (Object)word, (Object)this.matcher.end());
        }
        if (this.builderBuffer.length() > 0) {
            this.builderBuffer.append(content.substring(index));
            return this.builderBuffer.toString();
        }
        return content;
    }

    private static String createLiteralSearch(String search) {
        String[] tokens = search.split(" ");
        StringBuilder bldr = new StringBuilder();
        for (String token : tokens) {
            if (token.length() <= 0) continue;
            if (bldr.length() > 0) {
                bldr.append("|");
            }
            String literal = Pattern.quote(token);
            bldr.append(literal);
        }
        return bldr.toString();
    }
}

