/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.Application;
import org.limewire.core.api.Category;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.setting.Setting;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.options.ExtensionClassificationPanel;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.OptionPanelStateManager;
import org.limewire.ui.swing.options.UnsafeTypeOptionPanelStateManager;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.util.I18n;

public class UnsafeTypeOptionPanel
extends OptionPanel {
    private JCheckBox programCheckBox;
    private JCheckBox documentCheckBox;
    private JButton okButton;
    private final LibraryManager libraryManager;
    private final SharedFileListManager shareListManager;
    private final OptionPanelStateManager manager;
    private final Map<Setting, JCheckBox> settingMap;

    @Inject
    public UnsafeTypeOptionPanel(LibraryManager libraryManager, SharedFileListManager shareListManager, UnsafeTypeOptionPanelStateManager manager, final Provider<ExtensionClassificationPanel> extensionClassificationPanelProvider, Application application) {
        this.libraryManager = libraryManager;
        this.shareListManager = shareListManager;
        this.manager = manager;
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel(new MigLayout("nogrid"));
        contentPanel.setOpaque(false);
        this.programCheckBox = new JCheckBox(I18n.tr("Allow me to search for and share Programs with anyone"));
        this.programCheckBox.setContentAreaFilled(false);
        this.documentCheckBox = new JCheckBox(I18n.tr("Allow me to share Documents with the world"));
        this.documentCheckBox.setContentAreaFilled(false);
        this.okButton = new JButton(new OKDialogAction());
        this.settingMap = new HashMap<Setting, JCheckBox>();
        this.settingMap.put(LibrarySettings.ALLOW_PROGRAMS, this.programCheckBox);
        this.settingMap.put(LibrarySettings.ALLOW_DOCUMENT_GNUTELLA_SHARING, this.documentCheckBox);
        contentPanel.add((Component)new JLabel("<html>" + I18n.tr("Enabling this setting makes you more prone to accidently sharing personal information") + "</html>"), "wrap");
        contentPanel.add((Component)this.documentCheckBox, "gapleft 25");
        contentPanel.add((Component)new HyperlinkButton(new AbstractAction(I18n.tr("What are Documents?")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionClassificationPanel panel = (ExtensionClassificationPanel)extensionClassificationPanelProvider.get();
                panel.switchCategory(Category.DOCUMENT);
                panel.showDialogue();
            }
        }), "wrap");
        contentPanel.add((Component)new JSeparator(), "growx, gaptop 5, gapbottom 5, wrap");
        contentPanel.add((Component)new JLabel("<html>" + I18n.tr("Enabling this setting makes you more prone to viruses") + "</html>"), "wrap");
        contentPanel.add((Component)this.programCheckBox, "gapleft 25");
        contentPanel.add((Component)new HyperlinkButton(new AbstractAction(I18n.tr("What are Programs?")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionClassificationPanel panel = (ExtensionClassificationPanel)extensionClassificationPanelProvider.get();
                panel.switchCategory(Category.PROGRAM);
                panel.showDialogue();
            }
        }), "wrap");
        this.add((Component)contentPanel, "Center");
        JPanel buttonPanel = new JPanel(new MigLayout("fill"));
        buttonPanel.setOpaque(false);
        buttonPanel.add((Component)this.okButton, "tag ok");
        this.add((Component)buttonPanel, "South");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnsafeTypeOptionPanel.this.savePendingSettings();
            }
        });
    }

    @Inject
    public void register() {
        this.manager.addSettingChangedListener(new OptionPanelStateManager.SettingChangedListener(){

            @Override
            public void settingChanged(Setting setting) {
                ((JCheckBox)UnsafeTypeOptionPanel.this.settingMap.get(setting)).setSelected((Boolean)UnsafeTypeOptionPanel.this.manager.getValue(setting));
            }
        });
    }

    @Override
    boolean applyOptions() {
        this.manager.saveSettings();
        if (!this.programCheckBox.isSelected()) {
            this.libraryManager.getLibraryManagedList().removeFiles(new Predicate<LocalFileItem>(){

                @Override
                public boolean apply(LocalFileItem localFileItem) {
                    return localFileItem.getCategory() == Category.PROGRAM;
                }
            });
        }
        if (!this.documentCheckBox.isSelected()) {
            this.shareListManager.removeDocumentsFromPublicLists();
        }
        return false;
    }

    @Override
    boolean hasChanged() {
        return this.manager.hasPendingChanges();
    }

    @Override
    public void initOptions() {
        for (Setting setting : this.settingMap.keySet()) {
            this.settingMap.get(setting).setSelected((Boolean)this.manager.getValue(setting));
        }
    }

    private void savePendingSettings() {
        for (Setting setting : this.settingMap.keySet()) {
            this.manager.setValue(setting, this.settingMap.get(setting).isSelected());
        }
    }
}

