/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import org.limewire.activation.api.ActivationID;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationModuleEvent;
import org.limewire.core.api.Category;
import org.limewire.core.api.malware.VirusEngine;
import org.limewire.core.settings.MalwareSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.setting.FileSetting;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.LabelTextField;
import org.limewire.ui.swing.options.BitTorrentOptionPanel;
import org.limewire.ui.swing.options.LWSFileNamingOptionPanel;
import org.limewire.ui.swing.options.ManageSaveFoldersOptionPanel;
import org.limewire.ui.swing.options.ManageSaveFoldersOptionPanelFactory;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.TransferLimitsOptionPanel;
import org.limewire.ui.swing.options.actions.BrowseDirectoryAction;
import org.limewire.ui.swing.options.actions.CancelDialogAction;
import org.limewire.ui.swing.options.actions.DialogDisplayAction;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.ui.swing.util.ResizeUtils;
import org.limewire.ui.swing.util.SaveDirectoryHandler;

public class TransferOptionPanel
extends OptionPanel {
    private final Provider<IconManager> iconManager;
    private final ManageSaveFoldersOptionPanelFactory manageFoldersOptionPanelFactory;
    private final TransferLimitsOptionPanel connectionsOptionPanel;
    private final BitTorrentOptionPanel bitTorrentOptionPanel;
    private final VirusEngine virusEngine;
    private final String avgUrl = "http://www.limewire.com/download/pro?p=avg";
    private DownloadsPanel downloadsPanel;
    private TrayPanel trayPanel;
    private TransferPanel transferPanel;

    @Inject
    public TransferOptionPanel(Provider<IconManager> iconManager, ManageSaveFoldersOptionPanelFactory manageFoldersOptionPanelFactory, Provider<TransferLimitsOptionPanel> connectionOptionPanel, Provider<BitTorrentOptionPanel> bitTorrentOptionPanel, VirusEngine virusEngine) {
        this.iconManager = iconManager;
        this.manageFoldersOptionPanelFactory = manageFoldersOptionPanelFactory;
        this.connectionsOptionPanel = connectionOptionPanel.get();
        this.bitTorrentOptionPanel = bitTorrentOptionPanel.get();
        this.virusEngine = virusEngine;
        this.setLayout(new MigLayout("insets 15 15 15 15, fillx, wrap, gap 4"));
        this.add((Component)this.getDownloadsPanel(), "pushx, growx, wrap");
        this.add((Component)this.getTrayPanel(), "pushx, growx, wrap");
        this.add((Component)this.getTransfersPanel(), "pushx, growx, wrap");
        this.add((Component)new JButton(new DialogDisplayAction(this, this.bitTorrentOptionPanel, I18n.tr("Configure Torrent Settings"), I18n.tr("Configure Torrent Settings..."), I18n.tr("Configure torrent settings."))), "wrap");
    }

    @Inject
    public void register(ActivationManager activationManager) {
        activationManager.addModuleListener(new EventListener<ActivationModuleEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(ActivationModuleEvent event) {
                if (event.getData() == ActivationID.AVG_MODULE && TransferOptionPanel.this.downloadsPanel != null) {
                    TransferOptionPanel.this.downloadsPanel.setAVGCheckBoxVisible();
                    TransferOptionPanel.this.downloadsPanel.revalidate();
                }
            }
        });
    }

    private OptionPanel getDownloadsPanel() {
        if (this.downloadsPanel == null) {
            this.downloadsPanel = new DownloadsPanel();
        }
        return this.downloadsPanel;
    }

    private OptionPanel getTrayPanel() {
        if (this.trayPanel == null) {
            this.trayPanel = new TrayPanel();
        }
        return this.trayPanel;
    }

    private OptionPanel getTransfersPanel() {
        if (this.transferPanel == null) {
            this.transferPanel = new TransferPanel();
        }
        return this.transferPanel;
    }

    @Override
    boolean applyOptions() {
        return this.getDownloadsPanel().applyOptions() || this.getTrayPanel().applyOptions() || this.getTransfersPanel().applyOptions() || this.bitTorrentOptionPanel.applyOptions();
    }

    @Override
    boolean hasChanged() {
        return this.getDownloadsPanel().hasChanged() || this.getTrayPanel().hasChanged() || this.getTransfersPanel().hasChanged() || this.bitTorrentOptionPanel.hasChanged();
    }

    @Override
    public void initOptions() {
        this.getDownloadsPanel().initOptions();
        this.getTrayPanel().initOptions();
        this.getTransfersPanel().initOptions();
        this.bitTorrentOptionPanel.initOptions();
    }

    private class TransferPanel
    extends OptionPanel {
        public TransferPanel() {
            super(I18n.tr("Upload/Download Limits"));
            this.add((Component)new JLabel(I18n.tr("Set limits on downloads and uploads")), "split");
            this.add((Component)new JButton(new DialogDisplayAction(this, TransferOptionPanel.this.connectionsOptionPanel, I18n.tr("Transfer Limits"), I18n.tr("Settings..."), I18n.tr("Configure transfer limit settings."))), "wrap");
        }

        @Override
        boolean applyOptions() {
            return TransferOptionPanel.this.connectionsOptionPanel.applyOptions();
        }

        @Override
        boolean hasChanged() {
            return TransferOptionPanel.this.connectionsOptionPanel.hasChanged();
        }

        @Override
        public void initOptions() {
            TransferOptionPanel.this.connectionsOptionPanel.initOptions();
        }
    }

    private class TrayPanel
    extends OptionPanel {
        private JCheckBox closeTrayCheckBox;
        private JCheckBox showBandwidthCheckBox;
        private JCheckBox clearDownloadsCheckBox;
        private JCheckBox clearUploadCheckBox;

        public TrayPanel() {
            super(I18n.tr("Tray"));
            this.closeTrayCheckBox = new JCheckBox(I18n.tr("Close tray when there are no transfers"));
            this.closeTrayCheckBox.setOpaque(false);
            this.showBandwidthCheckBox = new JCheckBox(I18n.tr("Show total bandwidth"));
            this.showBandwidthCheckBox.setOpaque(false);
            this.clearDownloadsCheckBox = new JCheckBox(I18n.tr("Clear downloads from list when finished"));
            this.clearDownloadsCheckBox.setOpaque(false);
            this.clearUploadCheckBox = new JCheckBox(I18n.tr("Clear uploads from list when finished"));
            this.clearUploadCheckBox.setOpaque(false);
            this.add((Component)this.closeTrayCheckBox, "wrap");
            this.add((Component)this.showBandwidthCheckBox, "wrap");
            this.add((Component)this.clearDownloadsCheckBox, "wrap");
            this.add((Component)this.clearUploadCheckBox, "wrap");
        }

        @Override
        boolean applyOptions() {
            SwingUiSettings.HIDE_BOTTOM_TRAY_WHEN_NO_TRANSFERS.setValue(this.closeTrayCheckBox.isSelected());
            SwingUiSettings.SHOW_TOTAL_BANDWIDTH.setValue(this.showBandwidthCheckBox.isSelected());
            SharingSettings.CLEAR_DOWNLOAD.setValue(this.clearDownloadsCheckBox.isSelected());
            SharingSettings.CLEAR_UPLOAD.setValue(this.clearUploadCheckBox.isSelected());
            return false;
        }

        @Override
        boolean hasChanged() {
            return SwingUiSettings.HIDE_BOTTOM_TRAY_WHEN_NO_TRANSFERS.getValue() != this.closeTrayCheckBox.isSelected() || SwingUiSettings.SHOW_TOTAL_BANDWIDTH.getValue() != this.showBandwidthCheckBox.isSelected() || SharingSettings.CLEAR_DOWNLOAD.getValue() != this.clearDownloadsCheckBox.isSelected() || SharingSettings.CLEAR_UPLOAD.getValue() != this.clearUploadCheckBox.isSelected();
        }

        @Override
        public void initOptions() {
            this.closeTrayCheckBox.setSelected(SwingUiSettings.HIDE_BOTTOM_TRAY_WHEN_NO_TRANSFERS.getValue());
            this.showBandwidthCheckBox.setSelected(SwingUiSettings.SHOW_TOTAL_BANDWIDTH.getValue());
            this.clearDownloadsCheckBox.setSelected(SharingSettings.CLEAR_DOWNLOAD.getValue());
            this.clearUploadCheckBox.setSelected(SharingSettings.CLEAR_UPLOAD.getValue());
        }
    }

    private class DownloadsPanel
    extends OptionPanel {
        private String currentSaveDirectory;
        private final LabelTextField downloadSaveTextField;
        private final JButton browseSaveLocationButton;
        private final JCheckBox autoRenameDuplicateFilesCheckBox;
        private final JCheckBox useAntivirusCheckBox;
        private final ManageSaveFoldersOptionPanel saveFolderPanel;
        private LWSFileNamingOptionPanel storeOptionPanel;
        private final JButton multiLocationConfigureButton;
        private final JRadioButton singleLocationButton;
        private final JRadioButton multiLocationButton;
        private final HyperlinkButton buyAntivirusButton;

        public DownloadsPanel() {
            super(I18n.tr("Downloads"));
            ButtonGroup downloadOptions = new ButtonGroup();
            this.singleLocationButton = new JRadioButton(I18n.tr("Save all downloads to one folder:"));
            this.multiLocationButton = new JRadioButton(I18n.tr("Save different categories to different folders"));
            this.singleLocationButton.setOpaque(false);
            this.multiLocationButton.setOpaque(false);
            downloadOptions.add(this.singleLocationButton);
            downloadOptions.add(this.multiLocationButton);
            this.downloadSaveTextField = new LabelTextField(TransferOptionPanel.this.iconManager);
            this.downloadSaveTextField.setEditable(false);
            BrowseDirectoryAction directoryAction = new BrowseDirectoryAction(TransferOptionPanel.this, this.downloadSaveTextField);
            this.downloadSaveTextField.addMouseListener(directoryAction);
            this.browseSaveLocationButton = new JButton(directoryAction);
            this.autoRenameDuplicateFilesCheckBox = new JCheckBox(I18n.tr("If the file already exists, download it with a different name"));
            this.autoRenameDuplicateFilesCheckBox.setOpaque(false);
            this.useAntivirusCheckBox = new JCheckBox(I18n.tr("Scan files I download for viruses"));
            this.useAntivirusCheckBox.setOpaque(false);
            this.buyAntivirusButton = new HyperlinkButton("Upgrade to scan files with AVG Anti-Virus");
            this.buyAntivirusButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NativeLaunchUtils.openURL("http://www.limewire.com/download/pro?p=avg");
                }
            });
            this.add(this.singleLocationButton);
            this.add((Component)this.downloadSaveTextField, "span, growx");
            this.add((Component)this.browseSaveLocationButton, "wrap");
            this.saveFolderPanel = TransferOptionPanel.this.manageFoldersOptionPanelFactory.create(new OKDialogAction(), new CancelDialogAction());
            ResizeUtils.forceSize(this.saveFolderPanel, new Dimension(600, 430));
            this.storeOptionPanel = new LWSFileNamingOptionPanel(new OKDialogAction(), new CancelDialogAction());
            this.multiLocationConfigureButton = new JButton(new DialogDisplayAction(this, this.saveFolderPanel, I18n.tr("Download Folders"), I18n.tr("Configure..."), I18n.tr("Configure where different categories are downloaded")));
            this.add(this.multiLocationButton);
            this.add((Component)this.multiLocationConfigureButton, "wrap");
            this.add((Component)this.autoRenameDuplicateFilesCheckBox, "wrap");
            this.add((Component)this.useAntivirusCheckBox, "hidemode 3, wrap");
            ActionListener downloadSwitchAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DownloadsPanel.this.singleLocationButton.isSelected()) {
                        DownloadsPanel.this.downloadSaveTextField.setVisible(true);
                        DownloadsPanel.this.browseSaveLocationButton.setVisible(true);
                        DownloadsPanel.this.multiLocationConfigureButton.setVisible(false);
                    } else {
                        DownloadsPanel.this.downloadSaveTextField.setVisible(false);
                        DownloadsPanel.this.browseSaveLocationButton.setVisible(false);
                        DownloadsPanel.this.multiLocationConfigureButton.setVisible(true);
                    }
                }
            };
            this.singleLocationButton.addActionListener(downloadSwitchAction);
            this.multiLocationButton.addActionListener(downloadSwitchAction);
            if (((Boolean)SwingUiSettings.SHOW_STORE_COMPONENTS.get()).booleanValue()) {
                this.add(new JLabel(I18n.tr("Configure how LimeWire Store downloads are organized")));
                this.add((Component)new JButton(new DialogDisplayAction(TransferOptionPanel.this, this.storeOptionPanel, I18n.tr("Store File Organization"), I18n.tr("Configure..."), I18n.tr("Configure how files downloaded from the LimeWire Store are organized"))), "wrap");
            }
            this.add((Component)this.buyAntivirusButton, "hidemode 3, wrap");
        }

        @Override
        boolean applyOptions() {
            String save;
            if (this.singleLocationButton.isSelected() && this.saveFolderPanel.isConfigCustom()) {
                this.saveFolderPanel.revertToDefault();
            }
            SwingUiSettings.AUTO_RENAME_DUPLICATE_FILES.setValue(this.autoRenameDuplicateFilesCheckBox.isSelected());
            if (TransferOptionPanel.this.virusEngine.isSupported()) {
                boolean isReEnable = this.useAntivirusCheckBox.isSelected() && !MalwareSettings.VIRUS_SCANNER_ENABLED.getValue();
                MalwareSettings.VIRUS_SCANNER_ENABLED.setValue(this.useAntivirusCheckBox.isSelected());
                if (isReEnable) {
                    TransferOptionPanel.this.virusEngine.checkForUpdates();
                }
            }
            if (!(save = this.downloadSaveTextField.getText()).equals(this.currentSaveDirectory)) {
                try {
                    File saveDir = new File(save);
                    if (!SaveDirectoryHandler.isDirectoryValid(saveDir) && !saveDir.mkdirs()) {
                        throw new IOException();
                    }
                    SharingSettings.setSaveDirectory(saveDir);
                    this.updateMediaSaveDirectories(this.currentSaveDirectory, save);
                    this.currentSaveDirectory = save;
                }
                catch (Exception ioe) {
                    FocusJOptionPane.showMessageDialog(TransferOptionPanel.this, I18n.tr("Could not save download directory, reverted to old directory"), I18n.tr("Save Folder Error"), 0);
                    this.downloadSaveTextField.setText(this.currentSaveDirectory);
                }
            }
            return this.saveFolderPanel.applyOptions() || this.storeOptionPanel.applyOptions();
        }

        private void updateMediaSaveDirectories(String oldSaveDir, String newSaveDir) {
            this.updateMediaSaveDirectory(Category.AUDIO, oldSaveDir, newSaveDir);
            this.updateMediaSaveDirectory(Category.VIDEO, oldSaveDir, newSaveDir);
            this.updateMediaSaveDirectory(Category.IMAGE, oldSaveDir, newSaveDir);
            this.updateMediaSaveDirectory(Category.DOCUMENT, oldSaveDir, newSaveDir);
            this.updateMediaSaveDirectory(Category.PROGRAM, oldSaveDir, newSaveDir);
            this.updateMediaSaveDirectory(Category.OTHER, oldSaveDir, newSaveDir);
        }

        private void updateMediaSaveDirectory(Category category, String oldSaveDir, String newSaveDir) {
            String mediaSaveDir;
            FileSetting mediaSetting = SharingSettings.getFileSettingForCategory(category);
            if (!mediaSetting.isDefault() && (oldSaveDir.equals(mediaSaveDir = mediaSetting.get().getAbsolutePath()) || newSaveDir.equals(mediaSaveDir))) {
                mediaSetting.revertToDefault();
            }
        }

        @Override
        boolean hasChanged() {
            return !this.currentSaveDirectory.equals(this.downloadSaveTextField.getText()) || this.saveFolderPanel.hasChanged() || this.singleLocationButton.isSelected() && this.saveFolderPanel.isConfigCustom() || MalwareSettings.VIRUS_SCANNER_ENABLED.getValue() != this.useAntivirusCheckBox.isSelected() || SwingUiSettings.AUTO_RENAME_DUPLICATE_FILES.getValue() != this.autoRenameDuplicateFilesCheckBox.isSelected() || this.storeOptionPanel.hasChanged();
        }

        public void setAVGCheckBoxVisible() {
            boolean value = TransferOptionPanel.this.virusEngine.isSupported();
            this.useAntivirusCheckBox.setVisible(value);
            this.buyAntivirusButton.setVisible(!value);
        }

        @Override
        public void initOptions() {
            this.autoRenameDuplicateFilesCheckBox.setSelected(SwingUiSettings.AUTO_RENAME_DUPLICATE_FILES.getValue());
            this.useAntivirusCheckBox.setSelected(MalwareSettings.VIRUS_SCANNER_ENABLED.getValue());
            this.setAVGCheckBoxVisible();
            this.saveFolderPanel.initOptions();
            this.storeOptionPanel.initOptions();
            if (this.saveFolderPanel.isConfigCustom()) {
                this.multiLocationButton.doClick();
            } else {
                this.singleLocationButton.doClick();
            }
            try {
                File file = SharingSettings.getSaveDirectory();
                if (file == null && (file = SharingSettings.DEFAULT_SAVE_DIR) == null) {
                    throw new FileNotFoundException();
                }
                this.currentSaveDirectory = file.getCanonicalPath();
                this.downloadSaveTextField.setText(file.getCanonicalPath());
            }
            catch (FileNotFoundException fnfe) {
                this.currentSaveDirectory = "";
                this.downloadSaveTextField.setText("");
            }
            catch (IOException ioe) {
                this.currentSaveDirectory = "";
                this.downloadSaveTextField.setText("");
            }
        }
    }
}

