/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventUtils;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.library.navigator.CreateListAction;
import org.limewire.ui.swing.menu.DelayedMnemonicMenu;
import org.limewire.ui.swing.util.I18n;

public class ShareListMenu
extends DelayedMnemonicMenu {
    private final EventBean<FriendConnectionEvent> friendConnectionEventBean;
    private final Provider<SharedFileListManager> shareListManagerProvider;
    private final Provider<CreateListAction> createListActionProvider;
    private final Provider<LibraryMediator> libraryMediatorProvider;

    @Inject
    public ShareListMenu(EventBean<FriendConnectionEvent> friendConnectionEventBean, Provider<SharedFileListManager> shareListManagerProvider, Provider<CreateListAction> createListActionProvider, Provider<LibraryMediator> libraryMediatorProvider) {
        super(I18n.tr("&Share List"));
        this.friendConnectionEventBean = friendConnectionEventBean;
        this.shareListManagerProvider = shareListManagerProvider;
        this.createListActionProvider = createListActionProvider;
        this.libraryMediatorProvider = libraryMediatorProvider;
        this.createMenuItems();
    }

    @Override
    public void createMenuItems() {
        FriendConnection friendConnection = (FriendConnection)EventUtils.getSource(this.friendConnectionEventBean);
        if (friendConnection != null && friendConnection.isLoggedIn()) {
            for (final SharedFileList list : this.shareListManagerProvider.get().getModel()) {
                if (list.isPublic()) continue;
                this.add(new AbstractAction(I18n.tr(list.getCollectionName())){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((LibraryMediator)ShareListMenu.this.libraryMediatorProvider.get()).showSharedFileList(list, true);
                    }
                });
            }
            this.addSeparator();
            this.add(this.createListActionProvider.get());
        } else {
            this.setEnabled(false);
        }
    }
}

