/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationModuleEvent;
import org.limewire.core.api.Application;
import org.limewire.core.api.updates.UpdateEvent;
import org.limewire.core.api.updates.UpdateInformation;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.LimeSplitPane;
import org.limewire.ui.swing.components.PanelResizer;
import org.limewire.ui.swing.downloads.MainDownloadPanel;
import org.limewire.ui.swing.friends.login.LoginPopupPanel;
import org.limewire.ui.swing.mainframe.BottomHeaderPanel;
import org.limewire.ui.swing.mainframe.BottomPanel;
import org.limewire.ui.swing.mainframe.GlobalLayeredPane;
import org.limewire.ui.swing.mainframe.MainPanel;
import org.limewire.ui.swing.mainframe.SignOnMessageLayer;
import org.limewire.ui.swing.mainframe.TopPanel;
import org.limewire.ui.swing.pro.ProNagController;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.statusbar.SharedFileCountPopupPanel;
import org.limewire.ui.swing.statusbar.StatusPanel;
import org.limewire.ui.swing.update.UpdatePanel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;

public class LimeWireSwingUI
extends JPanel {
    private final JPanel centerPanel;
    private final TopPanel topPanel;
    private final JLayeredPane layeredPane;
    private final ProNagController proNagController;
    private final LimeSplitPane splitPane;
    private final Provider<SignOnMessageLayer> signOnMessageProvider;
    private final BottomHeaderPanel bottomHeaderPanel;
    private boolean isPro = false;

    @Inject
    public LimeWireSwingUI(TopPanel topPanel, MainPanel mainPanel, StatusPanel statusPanel, ProNagController proNagController, SharedFileCountPopupPanel sharedFileCountPopup, LoginPopupPanel loginPopup, Provider<SignOnMessageLayer> signOnMessageProvider, MainDownloadPanel mainDownloadPanel, @GlobalLayeredPane JLayeredPane limeWireLayeredPane, BottomPanel bottomPanel, BottomHeaderPanel bottomHeaderPanel) {
        GuiUtils.assignResources(this);
        this.topPanel = topPanel;
        this.layeredPane = limeWireLayeredPane;
        this.proNagController = proNagController;
        this.signOnMessageProvider = signOnMessageProvider;
        this.centerPanel = new JPanel(new GridBagLayout());
        this.bottomHeaderPanel = bottomHeaderPanel;
        this.splitPane = this.createSplitPane(mainPanel, bottomPanel, bottomHeaderPanel);
        this.setLayout(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        this.centerPanel.add((Component)topPanel, gbc);
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        this.centerPanel.add((Component)this.splitPane, gbc);
        this.layeredPane.addComponentListener(new MainPanelResizer(this.centerPanel));
        this.layeredPane.add((Component)this.centerPanel, JLayeredPane.DEFAULT_LAYER);
        this.layeredPane.add((Component)sharedFileCountPopup, JLayeredPane.PALETTE_LAYER);
        this.layeredPane.addComponentListener(new PanelResizer(sharedFileCountPopup));
        this.layeredPane.add((Component)loginPopup, JLayeredPane.POPUP_LAYER);
        this.layeredPane.addComponentListener(new PanelResizer(loginPopup));
        this.add((Component)this.layeredPane, "Center");
        this.add((Component)statusPanel, "South");
    }

    @Inject
    public void registerListener(final ActivationManager activationManager) {
        SwingUiSettings.SHOW_TRANSFERS_TRAY.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        LimeWireSwingUI.this.setBottomTrayVisible(SwingUiSettings.SHOW_TRANSFERS_TRAY.getValue());
                    }
                });
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent e) {
                if (SwingUiSettings.SHOW_TRANSFERS_TRAY.getValue()) {
                    LimeWireSwingUI.this.setBottomTrayVisible(true);
                }
                LimeWireSwingUI.this.updateTitle();
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent e) {
            }
        });
        this.isPro = activationManager.isProActive();
        activationManager.addModuleListener(new EventListener<ActivationModuleEvent>(){

            @Override
            public void handleEvent(ActivationModuleEvent event) {
                if (LimeWireSwingUI.this.isPro != activationManager.isProActive()) {
                    LimeWireSwingUI.this.isPro = activationManager.isProActive();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LimeWireSwingUI.this.updateTitle();
                        }
                    });
                }
            }
        });
    }

    private void updateTitle() {
        if (this.getRootPane() == null) {
            return;
        }
        JFrame frame = (JFrame)this.getRootPane().getParent();
        String title = frame.getTitle();
        if (title == null) {
            return;
        }
        if (this.isPro) {
            if (!title.endsWith("PRO")) {
                title = title + " PRO";
            }
        } else if (title.endsWith("PRO")) {
            title = title.substring(0, title.length() - 4);
        }
        frame.setTitle(title);
    }

    void hideMainPanel() {
        this.layeredPane.setVisible(false);
        this.centerPanel.setVisible(false);
    }

    void showMainPanel() {
        this.layeredPane.setVisible(true);
        this.centerPanel.setVisible(true);
    }

    void loadProNag() {
        this.proNagController.showNagIfReady(this.layeredPane);
    }

    public void goHome() {
        this.topPanel.goHome();
    }

    public void focusOnSearch() {
        this.topPanel.requestFocusInWindow();
    }

    private LimeSplitPane createSplitPane(final JComponent top, final BottomPanel bottom, BottomHeaderPanel bottomHeaderPanel) {
        final LimeSplitPane splitPane = new LimeSplitPane(0, true, top, bottom, bottomHeaderPanel.getComponent());
        splitPane.setDividerSize(0);
        bottom.setVisible(false);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        bottomHeaderPanel.setParentSplitPane(splitPane);
        bottom.setMinimumSize(new Dimension(0, 0));
        splitPane.setResizeWeight(1.0);
        splitPane.setDividerDraggable(false);
        splitPane.setDragComponent(bottomHeaderPanel.getDragComponent());
        splitPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                top.setMinimumSize(new Dimension(0, splitPane.getHeight() / 2));
            }
        });
        bottom.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int minHeight;
                int height = bottom.getHeight();
                if (height > (minHeight = bottom.getDefaultPreferredHeight())) {
                    SwingUiSettings.BOTTOM_TRAY_SIZE.setValue(height);
                } else {
                    SwingUiSettings.BOTTOM_TRAY_SIZE.setValue(minHeight);
                }
            }
        });
        return splitPane;
    }

    private void setBottomTrayVisible(boolean visible) {
        assert (SwingUtilities.isEventDispatchThread());
        boolean wasVisible = this.splitPane.getBottomComponent().isVisible();
        this.splitPane.getBottomComponent().setVisible(visible);
        this.splitPane.setDividerSize(visible ? this.bottomHeaderPanel.getComponentHeight() : 0);
        if (visible) {
            if (!wasVisible) {
                int lastLocation = this.splitPane.getLastDividerLocation();
                if (lastLocation <= 0 || lastLocation > this.splitPane.getHeight()) {
                    int preferredDividerPosition = this.splitPane.getSize().height - this.splitPane.getInsets().bottom - this.splitPane.getDividerSize() - this.splitPane.getBottomComponent().getPreferredSize().height;
                    if (preferredDividerPosition < this.splitPane.getHeight() / 2) {
                        preferredDividerPosition = this.splitPane.getHeight() / 2;
                    }
                    this.splitPane.setDividerLocation(preferredDividerPosition);
                } else {
                    this.splitPane.setDividerLocation(lastLocation);
                }
            }
        } else if (wasVisible) {
            this.splitPane.setLastDividerLocation(this.splitPane.getDividerLocation());
        }
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    @Inject
    void register(ListenerSupport<UpdateEvent> updateEvent, ListenerSupport<FriendConnectionEvent> connectionSupport, final Application application) {
        updateEvent.addListener(new EventListener<UpdateEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(UpdateEvent event) {
                UpdatePanel updatePanel = new UpdatePanel((UpdateInformation)event.getData(), application);
                JDialog dialog = FocusJOptionPane.createDialog(I18n.tr("New Version Available!"), null, updatePanel);
                dialog.setLocationRelativeTo(GuiUtils.getMainFrame());
                dialog.getRootPane().setDefaultButton(updatePanel.getDefaultButton());
                dialog.setModal(false);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        if (SignOnMessageLayer.isSignOnMessageEnabled()) {
            connectionSupport.addListener(new EventListener<FriendConnectionEvent>(){

                @Override
                @SwingEDTEvent
                public void handleEvent(FriendConnectionEvent event) {
                    if (event.getType() == FriendConnectionEvent.Type.CONNECTED) {
                        ((SignOnMessageLayer)LimeWireSwingUI.this.signOnMessageProvider.get()).showMessage();
                    }
                }
            });
        }
    }

    private static class MainPanelResizer
    extends ComponentAdapter {
        private final JComponent target;

        public MainPanelResizer(JComponent target) {
            this.target = target;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Rectangle parentBounds = e.getComponent().getBounds();
            this.target.setBounds(0, 0, (int)parentBounds.getWidth(), (int)parentBounds.getHeight());
            this.target.revalidate();
        }
    }
}

