/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.library.LibraryInspectionUtils;
import org.limewire.ui.swing.library.LibrarySelected;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.player.Audio;
import org.limewire.ui.swing.player.PlayerMediator;
import org.limewire.ui.swing.player.PlayerUtils;
import org.limewire.ui.swing.player.Video;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;

class LaunchFileAction
extends AbstractAction {
    private final Provider<List<LocalFileItem>> selectedLocalFileItems;
    private final Provider<LibraryNavigatorPanel> libraryNavProvider;
    private final Provider<PlayerMediator> audioPlayerProvider;
    private final Provider<PlayerMediator> videoPlayerProvider;
    private final CategoryManager categoryManager;

    @Inject
    public LaunchFileAction(@LibrarySelected Provider<List<LocalFileItem>> selectedLocalFileItems, Provider<LibraryNavigatorPanel> libraryNavProvider, @Audio Provider<PlayerMediator> audioPlayerProvider, @Video Provider<PlayerMediator> videoPlayerProvider, CategoryManager categoryManager) {
        super(I18n.tr("Play/Open"));
        this.selectedLocalFileItems = selectedLocalFileItems;
        this.libraryNavProvider = libraryNavProvider;
        this.audioPlayerProvider = audioPlayerProvider;
        this.videoPlayerProvider = videoPlayerProvider;
        this.categoryManager = categoryManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList localFileItems = new ArrayList(this.selectedLocalFileItems.get());
        if (localFileItems.size() > 0) {
            LibraryInspectionUtils.fileLaunched();
            LocalFileItem fileItem = (LocalFileItem)localFileItems.get(0);
            if (SwingUiSettings.PLAYER_ENABLED.getValue() && PlayerUtils.isPlayableAudioFile(fileItem.getFile())) {
                this.audioPlayerProvider.get().setActivePlaylist(this.libraryNavProvider.get().getSelectedNavItem());
                this.audioPlayerProvider.get().play(fileItem);
            } else if (SwingUiSettings.PLAYER_ENABLED.getValue() && PlayerUtils.isPlayableVideoFile(fileItem.getFile(), this.categoryManager)) {
                PlayerUtils.stop();
                this.videoPlayerProvider.get().play(fileItem);
            } else {
                NativeLaunchUtils.safeLaunchFile(fileItem.getFile(), this.categoryManager);
            }
        }
    }
}

