/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.FileItem;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.library.table.AbstractLibraryFormat;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.table.TrackComparator;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.PropertyUtils;

public class AudioTableFormat<T extends LocalFileItem>
extends AbstractLibraryFormat<T> {
    static final int PLAY_INDEX = 0;
    static final int TITLE_INDEX = 1;
    static final int ARTIST_INDEX = 2;
    static final int ALBUM_INDEX = 3;
    static final int LENGTH_INDEX = 4;
    static final int GENRE_INDEX = 5;
    static final int BITRATE_INDEX = 6;
    static final int SIZE_INDEX = 7;
    static final int FILENAME_INDEX = 8;
    static final int TRACK_INDEX = 9;
    static final int YEAR_INDEX = 10;
    static final int DESCRIPTION_INDEX = 11;
    static final int HIT_INDEX = 12;
    static final int UPLOADS_INDEX = 13;
    static final int UPLOAD_ATTEMPTS_INDEX = 14;
    static final int PATH_INDEX = 15;
    static final int ACTION_INDEX = 16;

    @Inject
    public AudioTableFormat() {
        super(16, "LIBRARY_AUDIO_TABLE", 2, true, new ColumnStateInfo(0, "LIBRARY_AUDIO_PLAY", "", 16, 16, true, false), new ColumnStateInfo(1, "LIBRARY_AUDIO_TITLE", I18n.tr("Name"), 274, true, true), new ColumnStateInfo(2, "LIBRARY_AUDIO_ARTIST", I18n.tr("Artist"), 182, true, true), new ColumnStateInfo(3, "LIBRARY_AUDIO_ALBUM", I18n.tr("Album"), 163, true, true), new ColumnStateInfo(4, "LIBRARY_AUDIO_LENGTH", I18n.tr("Length"), 59, true, true), new ColumnStateInfo(5, "LIBRARY_AUDIO_GENRE", I18n.tr("Genre"), 60, false, true), new ColumnStateInfo(6, "LIBRARY_AUDIO_BITRATE", I18n.tr("Bitrate"), 50, false, true), new ColumnStateInfo(7, "LIBRARY_AUDIO_SIZE", I18n.tr("Size"), 50, false, true), new ColumnStateInfo(8, "LIBRARY_AUDIO_FILENAME", I18n.tr("Filename"), 100, false, true), new ColumnStateInfo(9, "LIBRARY_AUDIO_TRACK", I18n.tr("Track"), 50, false, true), new ColumnStateInfo(10, "LIBRARY_AUDIO_YEAR", I18n.tr("Year"), 50, false, true), new ColumnStateInfo(11, "LIBRARY_AUDIO_DESCRIPTION_UNUSED", I18n.tr("Description"), 100, false, false), new ColumnStateInfo(12, "LIBRARY_AUDIO_HITS", I18n.tr("Hits"), 100, false, true), new ColumnStateInfo(13, "LIBRARY_AUDIO_UPLOADS", I18n.tr("Uploads"), 100, false, true), new ColumnStateInfo(14, "LIBRARY_AUDIO_UPLOAD_ATTEMPTS", I18n.tr("Upload attempts"), 200, false, true), new ColumnStateInfo(15, "LIBRARY_AUDIO_PATH", I18n.tr("Location"), 200, false, true), new ColumnStateInfo(16, "LIBRARY_AUDIO_ACTION", I18n.tr(" "), 22, 22, true, false));
    }

    @Override
    public Object getColumnValue(T baseObject, int column) {
        switch (column) {
            case 0: {
                return baseObject;
            }
            case 1: {
                return baseObject;
            }
            case 2: {
                return baseObject.getProperty(FilePropertyKey.AUTHOR);
            }
            case 3: {
                return baseObject.getProperty(FilePropertyKey.ALBUM);
            }
            case 4: {
                return baseObject.getProperty(FilePropertyKey.LENGTH);
            }
            case 5: {
                return baseObject.getProperty(FilePropertyKey.GENRE);
            }
            case 6: {
                return baseObject.getProperty(FilePropertyKey.BITRATE);
            }
            case 8: {
                return baseObject.getFileName();
            }
            case 7: {
                return baseObject.getSize();
            }
            case 9: {
                return baseObject.getProperty(FilePropertyKey.TRACK_NUMBER);
            }
            case 10: {
                return baseObject.getProperty(FilePropertyKey.YEAR);
            }
            case 11: {
                return baseObject.getProperty(FilePropertyKey.DESCRIPTION);
            }
            case 12: {
                return baseObject.getNumHits();
            }
            case 14: {
                return baseObject.getNumUploadAttempts();
            }
            case 13: {
                return baseObject.getNumUploads();
            }
            case 15: {
                return baseObject.getProperty(FilePropertyKey.LOCATION);
            }
            case 16: {
                return baseObject;
            }
        }
        throw new IllegalArgumentException("Unknown column:" + column);
    }

    @Override
    public Class getColumnClass(int column) {
        switch (column) {
            case 0: 
            case 1: {
                return FileItem.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 1: {
                return new NameComparator();
            }
            case 9: {
                return new TrackComparator();
            }
        }
        return super.getColumnComparator(column);
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        if (TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue() == this.getSortedColumn() && TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() == this.getSortOrder()) {
            return Arrays.asList(new SortKey(SortOrder.ASCENDING, 2), new SortKey(SortOrder.ASCENDING, 3), new SortKey(SortOrder.ASCENDING, 9), new SortKey(SortOrder.ASCENDING, 1));
        }
        return super.getDefaultSortKeys();
    }

    @Override
    public List<Integer> getSecondarySortColumns(int column) {
        switch (column) {
            case 2: {
                return Arrays.asList(3, 9, 1);
            }
            case 3: {
                return Arrays.asList(9, 1);
            }
        }
        return Collections.emptyList();
    }

    private class NameComparator
    implements Comparator<FileItem> {
        private NameComparator() {
        }

        @Override
        public int compare(FileItem o1, FileItem o2) {
            String title1 = PropertyUtils.getTitle(o1);
            String title2 = PropertyUtils.getTitle(o2);
            return title1.toLowerCase(Locale.US).compareTo(title2.toLowerCase(Locale.US));
        }
    }
}

