/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.sharing;

import ca.odell.glazedlists.EventList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.components.HTMLLabel;
import org.limewire.ui.swing.friends.actions.LoginAction;
import org.limewire.ui.swing.library.sharing.StopSharingAction;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class LibrarySharingLoginPanel {
    @Resource
    private Font textFont;
    private static final String SIGN_IN = "#signin";
    private static final String STOP_SHARING = "#stopsharing";
    private final HTMLLabel htmlLabel;
    private final JPanel component;
    private boolean hasShared;
    private boolean loggedOut;

    @Inject
    public LibrarySharingLoginPanel(final Provider<LoginAction> loginAction, final Provider<StopSharingAction> stopSharing) {
        GuiUtils.assignResources(this);
        this.component = new JPanel(new MigLayout("", "134!", ""));
        this.component.setOpaque(false);
        this.htmlLabel = new HTMLLabel("<html>" + I18n.tr("<a href={0}>Sign in</a> to share this list.", SIGN_IN) + "</html>");
        this.htmlLabel.setHtmlFont(this.textFont);
        this.htmlLabel.setOpenUrlsNatively(false);
        this.htmlLabel.setOpaque(false);
        this.htmlLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    if (e.getDescription().equals(LibrarySharingLoginPanel.SIGN_IN)) {
                        ((LoginAction)loginAction.get()).actionPerformed(null);
                    } else if (e.getDescription().equals(LibrarySharingLoginPanel.STOP_SHARING)) {
                        ((StopSharingAction)stopSharing.get()).actionPerformed(null);
                    }
                }
            }
        });
        this.component.add((Component)this.htmlLabel, "width 94%");
    }

    public JComponent getComponent() {
        return this.component;
    }

    void setSharedFriendIds(EventList<String> friendIds) {
        this.hasShared = !friendIds.isEmpty();
        this.setMessage();
    }

    private void setMessage() {
        if (!this.loggedOut) {
            this.htmlLabel.setText("<html>" + I18n.tr("Logging in...") + "</html>");
        } else if (this.hasShared) {
            this.htmlLabel.setText("<html>" + I18n.tr("<a href={0}>Sign in</a> to share this list or edit sharing, or <a href={1}>stop sharing</a> it now.", SIGN_IN, STOP_SHARING) + "</html>");
        } else {
            this.htmlLabel.setText("<html>" + I18n.tr("<a href={0}>Sign in</a> to share this list.", SIGN_IN) + "</html>");
        }
    }

    void setLoggingIn(boolean loggingIn) {
        this.loggedOut = !loggingIn;
        this.setMessage();
    }
}

