/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.sharing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXTable;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendEvent;
import org.limewire.inject.LazySingleton;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.library.sharing.EditSharingAction;
import org.limewire.ui.swing.library.sharing.LibrarySharingFriendListRenderer;
import org.limewire.ui.swing.table.GlazedJXTable;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

@LazySingleton
class LibrarySharingFriendListPanel {
    @Resource
    private Font labelFont;
    @Resource
    private Color labelColor;
    @Resource
    private Font linkFont;
    @Resource
    private Color backgroundColor;
    private final JPanel component;
    private final JLabel headerLabel;
    private final HyperlinkButton editButton;
    private final Map<String, Friend> knownFriends;
    private final List<String> sharedIds;
    private final LibrarySharingFriendListRenderer renderer;
    private final EventList<String> eventList;
    private final JXTable friendList;
    private final JScrollPane scrollPane;

    @Inject
    public LibrarySharingFriendListPanel(EditSharingAction sharingAction, @Named(value="known") Map<String, Friend> knownFriends) {
        GuiUtils.assignResources(this);
        this.knownFriends = knownFriends;
        this.friendList = new GlazedJXTable();
        this.sharedIds = new ArrayList<String>();
        this.eventList = new BasicEventList<String>();
        SortedList<String> sortedList = GlazedListsFactory.sortedList(this.eventList, new FriendComparator());
        SwingThreadProxyEventList<String> stpl = GlazedListsFactory.swingThreadProxyEventList(sortedList);
        this.friendList.setModel(new DefaultEventTableModel<String>(stpl, new FriendTableFormat()));
        this.component = new JPanel(new MigLayout("insets 0, gap 0, fillx", "134!", ""));
        this.component.setOpaque(false);
        this.headerLabel = new JLabel();
        this.headerLabel.setFont(this.labelFont);
        this.headerLabel.setForeground(this.labelColor);
        this.component.add((Component)this.headerLabel, "aligny top, gaptop 8, gapleft 6, gapbottom 6, wrap");
        this.friendList.setTableHeader(null);
        this.friendList.setShowGrid(false, false);
        this.friendList.setFocusable(false);
        this.friendList.setBackground(this.backgroundColor);
        this.scrollPane = new JScrollPane(this.friendList, 20, 31);
        this.scrollPane.setMinimumSize(new Dimension(0, 0));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        this.scrollPane.setBackground(this.backgroundColor);
        this.renderer = new LibrarySharingFriendListRenderer(this.scrollPane);
        this.friendList.getColumnExt(0).setCellRenderer(this.renderer);
        this.component.add((Component)this.scrollPane, "grow, wrap");
        this.editButton = new HyperlinkButton(I18n.tr("Edit Sharing"), sharingAction);
        this.editButton.setFont(this.linkFont);
        this.component.add((Component)this.editButton, "aligny top, gaptop 5, gapleft 6, gapbottom 5, wrap");
        this.scrollPane.getVerticalScrollBar().addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                LibrarySharingFriendListPanel.this.scrollPane.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            }

            @Override
            public void componentShown(ComponentEvent e) {
                LibrarySharingFriendListPanel.this.scrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.BLACK));
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
    }

    @Inject
    void register(@Named(value="known") ListenerSupport<FriendEvent> friendSupport) {
        friendSupport.addListener(new EventListener<FriendEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendEvent event) {
                switch ((FriendEvent.Type)((Object)event.getType())) {
                    case ADDED: {
                        LibrarySharingFriendListPanel.this.setSharedFriendIds(LibrarySharingFriendListPanel.this.sharedIds);
                    }
                }
            }
        });
    }

    void clear() {
        this.eventList.clear();
    }

    void setSharedFriendIds(List<String> newFriendIds) {
        if (!newFriendIds.isEmpty()) {
            this.headerLabel.setText(I18n.tr("Sharing list with..."));
        } else {
            this.headerLabel.setText(I18n.tr("Not Shared"));
        }
        if (newFriendIds != this.sharedIds) {
            this.sharedIds.clear();
            this.sharedIds.addAll(new ArrayList<String>(newFriendIds));
        }
        ArrayList<String> newModel = new ArrayList<String>();
        int unknown = 0;
        for (String id : this.sharedIds) {
            Friend friend = this.knownFriends.get(id);
            if (friend != null) {
                newModel.add(friend.getRenderName());
                continue;
            }
            ++unknown;
        }
        if (unknown > 0) {
            newModel.add(I18n.tr("{0} friends from other accounts", unknown));
            this.friendList.setRowHeightEnabled(true);
        } else {
            this.friendList.setRowHeightEnabled(false);
        }
        this.eventList.clear();
        this.eventList.addAll(newModel);
        this.friendList.setVisibleRowCount(newModel.size());
        this.component.revalidate();
    }

    JComponent getComponent() {
        return this.component;
    }

    private static class FriendTableFormat
    implements TableFormat<String> {
        private FriendTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        @Override
        public Object getColumnValue(String baseObject, int column) {
            return baseObject;
        }
    }

    private static class FriendComparator
    implements Comparator<String> {
        private FriendComparator() {
        }

        @Override
        public int compare(String name1, String name2) {
            return name1.compareToIgnoreCase(name2);
        }
    }
}

