/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.filter.BitRateFilterFormat;
import org.limewire.ui.swing.filter.CategoryFilter;
import org.limewire.ui.swing.filter.FileSizeFilterFormat;
import org.limewire.ui.swing.filter.Filter;
import org.limewire.ui.swing.filter.FilterType;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.FilterableSource;
import org.limewire.ui.swing.filter.LengthFilterFormat;
import org.limewire.ui.swing.filter.PropertyFilter;
import org.limewire.ui.swing.filter.QualityFilterFormat;
import org.limewire.ui.swing.filter.RangeFilter;
import org.limewire.ui.swing.filter.SourceFilter;
import org.limewire.ui.swing.util.IconManager;

public class FilterManager<E extends FilterableItem>
implements Disposable {
    private final FilterableSource<E> filterableSource;
    private final Provider<IconManager> iconManager;
    private final Map<FilterType, Filter<E>> filterMap = new EnumMap<FilterType, Filter<E>>(FilterType.class);
    private final Map<FilePropertyKey, Filter<E>> propertyFilterMap = new EnumMap<FilePropertyKey, Filter<E>>(FilePropertyKey.class);

    public FilterManager(FilterableSource<E> filterableSource, Provider<IconManager> iconManager) {
        this.filterableSource = filterableSource;
        this.iconManager = iconManager;
    }

    @Override
    public void dispose() {
        Collection<Filter<E>> filters = this.filterMap.values();
        for (Filter<E> filter : filters) {
            filter.dispose();
        }
        Collection<Filter<E>> propertyFilters = this.propertyFilterMap.values();
        for (Filter<E> filter : propertyFilters) {
            filter.dispose();
        }
    }

    public List<Filter<E>> getFiltersInUse() {
        ArrayList<Filter<Filter<E>>> filterList = new ArrayList<Filter<Filter<E>>>();
        filterList.addAll(this.filterMap.values());
        filterList.addAll(this.propertyFilterMap.values());
        return filterList;
    }

    public CategoryFilter<E> getCategoryFilter() {
        return (CategoryFilter)this.getFilter(FilterType.CATEGORY);
    }

    public SourceFilter<E> getSourceFilter() {
        return (SourceFilter)this.getFilter(FilterType.SOURCE);
    }

    public int getPropertyFilterMinimum(SearchCategory filterCategory) {
        return filterCategory == SearchCategory.AUDIO ? 3 : -1;
    }

    public List<Filter<E>> getPropertyFilterList(SearchCategory filterCategory) {
        ArrayList<Filter<Filter<E>>> filterList = new ArrayList<Filter<Filter<E>>>();
        switch (filterCategory) {
            case AUDIO: {
                filterList.add(this.getPropertyFilter(FilePropertyKey.AUTHOR));
                filterList.add(this.getPropertyFilter(FilePropertyKey.ALBUM));
                filterList.add(this.getPropertyFilter(FilePropertyKey.GENRE));
                filterList.add(this.getFilter(FilterType.FILE_SIZE, filterCategory));
                filterList.add(this.getFilter(FilterType.EXTENSION));
                filterList.add(this.getFilter(FilterType.BIT_RATE));
                filterList.add(this.getFilter(FilterType.LENGTH));
                break;
            }
            case VIDEO: {
                filterList.add(this.getFilter(FilterType.FILE_SIZE, filterCategory));
                filterList.add(this.getFilter(FilterType.EXTENSION));
                filterList.add(this.getFilter(FilterType.QUALITY));
                filterList.add(this.getFilter(FilterType.LENGTH));
                break;
            }
            case DOCUMENT: 
            case OTHER: {
                filterList.add(this.getFilter(FilterType.FILE_TYPE));
                filterList.add(this.getFilter(FilterType.FILE_SIZE, filterCategory));
                filterList.add(this.getFilter(FilterType.EXTENSION));
                break;
            }
            default: {
                filterList.add(this.getFilter(FilterType.FILE_SIZE, filterCategory));
                filterList.add(this.getFilter(FilterType.EXTENSION));
            }
        }
        return filterList;
    }

    private Filter<E> getFilter(FilterType filterType) {
        Filter<E> filter = this.filterMap.get((Object)filterType);
        if (filter == null) {
            filter = this.createFilter(filterType, null);
            this.filterMap.put(filterType, filter);
        }
        return filter;
    }

    private Filter<E> getFilter(FilterType filterType, SearchCategory filterCategory) {
        Filter<E> filter = this.getFilter(filterType);
        if (filter instanceof RangeFilter) {
            ((RangeFilter)filter).updateRange(filterCategory);
        }
        return filter;
    }

    private Filter<E> getPropertyFilter(FilePropertyKey propertyKey) {
        Filter<E> filter = this.propertyFilterMap.get((Object)propertyKey);
        if (filter == null) {
            filter = this.createFilter(FilterType.PROPERTY, propertyKey);
            this.propertyFilterMap.put(propertyKey, filter);
        }
        return filter;
    }

    private Filter<E> createFilter(FilterType filterType, FilePropertyKey propertyKey) {
        switch (filterType) {
            case BIT_RATE: {
                return new RangeFilter(new BitRateFilterFormat());
            }
            case CATEGORY: {
                return new CategoryFilter<E>(this.filterableSource.getFilteredList());
            }
            case EXTENSION: {
                return new PropertyFilter<E>(this.filterableSource.getFilteredList(), FilterType.EXTENSION, null, this.iconManager);
            }
            case FILE_SIZE: {
                return new RangeFilter(new FileSizeFilterFormat());
            }
            case FILE_TYPE: {
                return new PropertyFilter<E>(this.filterableSource.getFilteredList(), FilterType.FILE_TYPE, null, this.iconManager);
            }
            case LENGTH: {
                return new RangeFilter(new LengthFilterFormat());
            }
            case PROPERTY: {
                return new PropertyFilter<E>(this.filterableSource.getFilteredList(), FilterType.PROPERTY, propertyKey, this.iconManager);
            }
            case QUALITY: {
                return new RangeFilter(new QualityFilterFormat());
            }
            case SOURCE: {
                return new SourceFilter<E>(this.filterableSource.getFilteredList());
            }
        }
        throw new IllegalArgumentException("Invalid filter type " + (Object)((Object)filterType));
    }
}

