/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components.decorators;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.components.LimeProgressBar;
import org.limewire.ui.swing.painter.ProgressBarForegroundPainter;
import org.limewire.ui.swing.painter.factories.ProgressPainterFactory;

@LazySingleton
public class ProgressBarDecorator {
    private final Provider<ProgressPainterFactory> painterFactoryProvider;
    private ProgressPainterFactory painterFactory;

    @Inject
    ProgressBarDecorator(Provider<ProgressPainterFactory> painterFactory) {
        this.painterFactoryProvider = painterFactory;
    }

    public void decoratePlain(LimeProgressBar bar) {
        ProgressBarDecorator.decorateGeneral(bar);
        if (this.painterFactory == null) {
            this.painterFactory = this.painterFactoryProvider.get();
        }
        AbstractPainter<JProgressBar> foregroundPainter = this.painterFactory.createForegroundPainter();
        AbstractPainter<JComponent> backgroundPainter = this.painterFactory.createBackgroundPainter();
        bar.setForegroundPainter(foregroundPainter);
        bar.setBackgroundPainter(backgroundPainter);
        foregroundPainter.setCacheable(bar.hasCacheSupport());
        backgroundPainter.setCacheable(bar.hasCacheSupport());
    }

    public static void decorateStaticBasic(LimeProgressBar bar) {
        ProgressBarDecorator.decorateGeneral(bar);
        bar.setForegroundPainter(new ProgressBarForegroundPainter<JProgressBar>(new GradientPaint(0.0f, 0.0f, new Color(207, 248, 143), 0.0f, 1.0f, new Color(170, 203, 117)), Color.GRAY));
        bar.setBackgroundPainter(new RectanglePainter<JComponent>(Color.WHITE, new Color(39, 39, 39)));
    }

    public static void decorateStaticPro(LimeProgressBar bar) {
        ProgressBarDecorator.decorateGeneral(bar);
        bar.setForegroundPainter(new ProgressBarForegroundPainter<JProgressBar>((Paint)new GradientPaint(0.0f, 0.0f, new Color(3703759), 0.0f, 1.0f, new Color(1468328)), (Paint)Color.GRAY, new Color(4038143)));
        bar.setBackgroundPainter(new RectanglePainter<JComponent>(Color.WHITE, new Color(12651)));
    }

    private static void decorateGeneral(LimeProgressBar bar) {
        bar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }
}

