/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.util.GuiUtils;

class VolumeSliderUI
extends BasicSliderUI {
    @Resource
    private int preferredWidth;
    @Resource
    private int preferredHeight;
    @Resource
    private Icon thumbIcon;
    @Resource
    private Icon trackIcon;
    private BufferedImage verticalThumbImage;
    private BufferedImage verticalTrackImage;
    private BufferedImage horizontalThumbImage;
    private BufferedImage horizontalTrackImage;

    public VolumeSliderUI(JSlider b) {
        super(b);
        GuiUtils.assignResources(this);
        this.initResources();
    }

    private void initResources() {
        Graphics2D g2d;
        if (this.thumbIcon instanceof ImageIcon) {
            this.verticalThumbImage = new BufferedImage(this.thumbIcon.getIconWidth(), this.thumbIcon.getIconHeight(), 2);
            g2d = this.verticalThumbImage.createGraphics();
            g2d.drawImage(((ImageIcon)this.thumbIcon).getImage(), 0, 0, null);
            g2d.dispose();
            this.horizontalThumbImage = new BufferedImage(this.thumbIcon.getIconHeight(), this.thumbIcon.getIconWidth(), 2);
            g2d = this.horizontalThumbImage.createGraphics();
            g2d.translate(0, this.thumbIcon.getIconWidth());
            g2d.rotate(-1.5707963267948966);
            g2d.drawImage(((ImageIcon)this.thumbIcon).getImage(), 0, 0, null);
            g2d.dispose();
        }
        if (this.trackIcon instanceof ImageIcon) {
            this.verticalTrackImage = new BufferedImage(this.trackIcon.getIconWidth(), this.trackIcon.getIconHeight(), 2);
            g2d = this.verticalTrackImage.createGraphics();
            g2d.drawImage(((ImageIcon)this.trackIcon).getImage(), 0, 0, null);
            g2d.dispose();
            this.horizontalTrackImage = new BufferedImage(this.trackIcon.getIconHeight(), this.trackIcon.getIconWidth(), 2);
            g2d = this.horizontalTrackImage.createGraphics();
            g2d.translate(0, this.trackIcon.getIconWidth());
            g2d.rotate(-1.5707963267948966);
            g2d.drawImage(((ImageIcon)this.trackIcon).getImage(), 0, 0, null);
            g2d.dispose();
        }
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        if (this.horizontalThumbImage != null && this.horizontalTrackImage != null) {
            return new Dimension(Math.max(this.horizontalTrackImage.getWidth(), this.preferredHeight), Math.max(this.horizontalThumbImage.getHeight(), this.preferredWidth));
        }
        return new Dimension(this.preferredHeight, this.preferredWidth);
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        if (this.verticalThumbImage != null && this.verticalTrackImage != null) {
            return new Dimension(Math.max(this.verticalThumbImage.getWidth(), this.preferredWidth), Math.max(this.verticalTrackImage.getHeight(), this.preferredHeight));
        }
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension minimumSize = super.getMinimumSize(c);
        if (this.slider.getOrientation() == 1) {
            if (this.verticalThumbImage != null) {
                minimumSize.width = Math.max(this.verticalThumbImage.getWidth(), minimumSize.width);
            }
            if (this.verticalTrackImage != null) {
                minimumSize.height = Math.max(this.verticalTrackImage.getHeight(), minimumSize.height);
            }
        } else {
            if (this.horizontalThumbImage != null) {
                minimumSize.height = Math.max(this.horizontalThumbImage.getHeight(), minimumSize.height);
            }
            if (this.horizontalTrackImage != null) {
                minimumSize.width = Math.max(this.horizontalTrackImage.getWidth(), minimumSize.width);
            }
        }
        return minimumSize;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize = super.getPreferredSize(c);
        if (this.slider.getOrientation() == 1) {
            preferredSize.width = Math.max(this.preferredWidth, preferredSize.width);
        } else {
            preferredSize.height = Math.max(this.preferredWidth, preferredSize.height);
        }
        return preferredSize;
    }

    @Override
    protected void calculateTrackRect() {
        if (this.verticalTrackImage == null) {
            super.calculateTrackRect();
            return;
        }
        int centerSpacing = 0;
        if (this.slider.getOrientation() == 0) {
            centerSpacing = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                centerSpacing += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                centerSpacing += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - (this.horizontalTrackImage.getWidth() - this.horizontalThumbImage.getWidth() / 2)) / 2;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - centerSpacing) / 2;
            this.trackRect.width = this.horizontalTrackImage.getWidth() - this.horizontalThumbImage.getWidth() / 2;
            this.trackRect.height = this.thumbRect.height;
        } else {
            centerSpacing = this.thumbRect.width;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                if (this.slider.getPaintTicks()) {
                    centerSpacing += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    centerSpacing -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - centerSpacing) / 2;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - (this.verticalTrackImage.getHeight() - this.verticalThumbImage.getHeight() / 2)) / 2;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.verticalTrackImage.getHeight() - this.verticalThumbImage.getHeight() / 2;
        }
    }

    @Override
    protected Dimension getThumbSize() {
        BufferedImage thumbImage;
        BufferedImage bufferedImage = thumbImage = this.slider.getOrientation() == 1 ? this.verticalThumbImage : this.horizontalThumbImage;
        if (thumbImage != null) {
            return new Dimension(thumbImage.getWidth(), thumbImage.getHeight());
        }
        return super.getThumbSize();
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintTrack(Graphics g) {
        BufferedImage trackImage;
        BufferedImage bufferedImage = trackImage = this.slider.getOrientation() == 1 ? this.verticalTrackImage : this.horizontalTrackImage;
        if (trackImage != null) {
            Rectangle trackBounds = this.contentRect;
            int cx = (trackBounds.width - trackImage.getWidth()) / 2;
            int cy = (trackBounds.height - trackImage.getHeight()) / 2;
            Graphics gTemp = g.create();
            gTemp.translate(trackBounds.x + cx, trackBounds.y + cy);
            gTemp.drawImage(trackImage, 0, 0, null);
            gTemp.dispose();
        } else {
            super.paintTrack(g);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        BufferedImage thumbImage;
        BufferedImage bufferedImage = thumbImage = this.slider.getOrientation() == 1 ? this.verticalThumbImage : this.horizontalThumbImage;
        if (thumbImage != null) {
            Rectangle thumbBounds = this.thumbRect;
            Graphics gTemp = g.create();
            gTemp.translate(thumbBounds.x, thumbBounds.y);
            gTemp.drawImage(thumbImage, 0, 0, null);
            gTemp.dispose();
        } else {
            super.paintThumb(g);
        }
    }
}

