/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.limewire.ui.swing.advanced.TabPanel;
import org.limewire.ui.swing.advanced.connection.AddConnectionPanel;
import org.limewire.ui.swing.advanced.connection.ConnectionDetailPanel;
import org.limewire.ui.swing.advanced.connection.ConnectionSummaryPanel;
import org.limewire.ui.swing.advanced.connection.IncomingSearchPanel;

public class ConnectionsPanel
extends TabPanel
implements ActionListener {
    private static final int DEFAULT_DELAY = 1000;
    private Timer timer;
    private ConnectionSummaryPanel summaryPanel;
    private ConnectionDetailPanel detailPanel;
    private AddConnectionPanel addConnectionPanel;
    private IncomingSearchPanel incomingPanel;

    @Inject
    public ConnectionsPanel(ConnectionSummaryPanel summaryPanel, ConnectionDetailPanel detailPanel, AddConnectionPanel addConnectionPanel, IncomingSearchPanel incomingPanel) {
        this.summaryPanel = summaryPanel;
        this.detailPanel = detailPanel;
        this.addConnectionPanel = addConnectionPanel;
        this.incomingPanel = incomingPanel;
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new MigLayout("fill", "[left,fill]12[left,grow,fill]", "[top,fill]12[top]12[top,grow,fill]"));
        this.add((Component)this.summaryPanel, "cell 0 0");
        this.add((Component)this.detailPanel, "cell 1 0 1 2");
        this.add((Component)this.addConnectionPanel, "cell 0 1");
        this.add((Component)this.incomingPanel, "cell 0 2 2 1");
    }

    @Override
    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        if (this.summaryPanel != null) {
            this.summaryPanel.setBackground(bgColor);
        }
    }

    @Override
    public boolean isTabEnabled() {
        return true;
    }

    @Override
    public void initData() {
        this.summaryPanel.initData();
        this.detailPanel.initData();
        this.incomingPanel.initData();
        this.startTimer();
    }

    @Override
    public void dispose() {
        this.stopTimer();
        this.summaryPanel.dispose();
        this.detailPanel.dispose();
        this.incomingPanel.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.summaryPanel.refresh();
        this.detailPanel.refresh();
    }

    private void startTimer() {
        this.stopTimer();
        this.timer = new Timer(1000, this);
        this.timer.start();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this);
            this.timer = null;
        }
    }
}

