/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.file;

import java.io.File;
import org.limewire.swarm.SwarmFile;
import org.limewire.util.Objects;

public class SwarmFileImpl
implements SwarmFile {
    private final File file;
    private final long completeSize;
    private long startByte = 0L;
    private String path;

    public SwarmFileImpl(File file, String path, long completeSize) {
        this.file = Objects.nonNull(file, "file");
        assert (completeSize >= 0L);
        this.completeSize = completeSize;
        this.path = path;
        if (this.path == null) {
            this.path = file.getName();
        }
    }

    public SwarmFileImpl(File file, long completeSize) {
        this(file, file.getName(), completeSize);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public long getFileSize() {
        return this.completeSize;
    }

    @Override
    public long getStartBytePosition() {
        return this.startByte;
    }

    public void setStartByte(long startByte) {
        this.startByte = startByte;
    }

    @Override
    public long getEndBytePosition() {
        long endByte = this.getFileSize() > 0L ? this.getStartBytePosition() + this.getFileSize() - 1L : this.getStartBytePosition();
        return endByte;
    }
}

