/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.visual;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.math.BigDecimal;
import java.net.SocketAddress;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.messages.DHTMessage;

public abstract class Painter {
    private static final int SCALE = 10;
    public static final BigDecimal MAX_ID = new BigDecimal(KUID.MAXIMUM.toBigInteger(), 10);
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Stroke TWO_PIXEL_STROKE = new BasicStroke(2.0f);

    public abstract void paint(Component var1, Graphics2D var2);

    public abstract void handle(MessageDispatcher.MessageDispatcherEvent.EventType var1, KUID var2, SocketAddress var3, DHTMessage.OpCode var4, boolean var5);

    public abstract void clear();

    public static Stroke getStrokeForOpCode(DHTMessage.OpCode opcode) {
        float dash_phase = (float)Math.random() * 10.0f;
        switch (opcode) {
            case PING_REQUEST: 
            case PING_RESPONSE: {
                return new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{2.0f, 2.0f}, dash_phase);
            }
            case FIND_NODE_REQUEST: 
            case FIND_NODE_RESPONSE: {
                return new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{1.0f, 5.0f, 5.0f}, dash_phase);
            }
            case FIND_VALUE_REQUEST: 
            case FIND_VALUE_RESPONSE: {
                return new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{5.0f, 5.0f}, dash_phase);
            }
            case STORE_REQUEST: 
            case STORE_RESPONSE: {
                return new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{5.0f, 3.0f}, dash_phase);
            }
        }
        return DEFAULT_STROKE;
    }

    public static double position(KUID nodeId, double scale) {
        return Painter.position(new BigDecimal(nodeId.toBigInteger(), 10), scale);
    }

    public static double position(BigDecimal nodeId, double scale) {
        return nodeId.divide(MAX_ID, 4).multiply(BigDecimal.valueOf(scale)).doubleValue();
    }
}

