/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.result;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.result.LookupResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.security.SecurityToken;

public class FindValueResult
extends LookupResult {
    private final EntityKey lookupKey;
    private final Map<? extends Contact, ? extends SecurityToken> path;
    private final long time;
    private final int hop;
    private final Collection<? extends DHTValueEntity> entities;
    private final Collection<? extends EntityKey> entityKeys;

    public FindValueResult(EntityKey lookupKey, Map<? extends Contact, ? extends SecurityToken> path, Collection<? extends DHTValueEntity> entities, Collection<? extends EntityKey> entityKeys, long time, int hop) {
        super(lookupKey.getPrimaryKey());
        this.lookupKey = lookupKey;
        this.path = path;
        this.time = time;
        this.hop = hop;
        this.entities = new CopyOnWriteArrayList<DHTValueEntity>(entities);
        this.entityKeys = new CopyOnWriteArrayList<EntityKey>(entityKeys);
    }

    public EntityKey getLookupKey() {
        return this.lookupKey;
    }

    @Override
    public Collection<? extends Contact> getPath() {
        return this.path.keySet();
    }

    @Override
    public SecurityToken getSecurityToken(Contact node) {
        return this.path.get(node);
    }

    @Override
    public Collection<? extends Map.Entry<? extends Contact, ? extends SecurityToken>> getEntryPath() {
        return this.path.entrySet();
    }

    public Collection<? extends DHTValueEntity> getEntities() {
        return this.entities;
    }

    public Collection<? extends EntityKey> getEntityKeys() {
        return this.entityKeys;
    }

    public long getTime() {
        return this.time;
    }

    public int getHop() {
        return this.hop;
    }

    public boolean isSuccess() {
        return !this.entities.isEmpty() || !this.entityKeys.isEmpty();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getLookupID()).append(" (time=").append(this.time).append("ms, hop=").append(this.hop).append(")\n");
        if (!this.isSuccess()) {
            buffer.append("No values found!");
            return buffer.toString();
        }
        buffer.append(CollectionUtils.toString(this.entities));
        buffer.append(CollectionUtils.toString(this.entityKeys));
        return buffer.toString();
    }
}

