/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.handler.response.LookupResponseHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.mojito.statistics.FindValueLookupStatisticContainer;
import org.limewire.mojito.util.DatabaseUtils;
import org.limewire.security.SecurityToken;

public class FindValueResponseHandler
extends LookupResponseHandler<FindValueResult> {
    private static final Log LOG = LogFactory.getLog(FindValueResponseHandler.class);
    private boolean exchaustive = false;
    private final FindValueLookupStatisticContainer lookupStat;
    private final EntityKey lookupKey;
    private final Collection<EntityKey> entityKeys = new ArrayList<EntityKey>();
    private final Collection<DHTValueEntity> entities = new ArrayList<DHTValueEntity>();

    public FindValueResponseHandler(Context context, EntityKey lookupKey) {
        super(context, lookupKey.getPrimaryKey());
        this.lookupKey = lookupKey;
        this.setExhaustive(LookupSettings.EXHAUSTIVE_VALUE_LOOKUP.getValue());
        this.lookupStat = new FindValueLookupStatisticContainer(context, this.lookupId);
    }

    @Override
    protected void response(ResponseMessage message, long time) throws IOException {
        super.response(message, time);
        this.lookupStat.addReply();
    }

    @Override
    protected void timeout(KUID nodeId, SocketAddress dst, RequestMessage message, long time) throws IOException {
        super.timeout(nodeId, dst, message, time);
        this.lookupStat.addTimeout();
    }

    @Override
    protected boolean lookup(Contact node) throws IOException {
        if (super.lookup(node)) {
            this.lookupStat.addRequest();
            return true;
        }
        return false;
    }

    public void setExhaustive(boolean exchaustive) {
        this.exchaustive = exchaustive;
    }

    @Override
    protected void finishLookup() {
        long time = this.getElapsedTime();
        int currentHop = this.getCurrentHop();
        Map<Contact, SecurityToken> path = this.getPath();
        Collection<DHTValueEntity> entities = this.getDHTValueEntities();
        Collection<EntityKey> entityKeys = this.getEntityKeys();
        if (entities.isEmpty() && entityKeys.isEmpty()) {
            this.lookupStat.FIND_VALUE_FAILURE.incrementStat();
        } else {
            this.lookupStat.FIND_VALUE_OK.incrementStat();
        }
        this.lookupStat.setHops(currentHop, true);
        this.lookupStat.setTime((int)time, true);
        this.setReturnValue(new FindValueResult(this.lookupKey, path, entities, entityKeys, time, currentHop));
    }

    public EntityKey getLookupKey() {
        return this.lookupKey;
    }

    public Collection<DHTValueEntity> getDHTValueEntities() {
        return this.entities;
    }

    public Collection<EntityKey> getEntityKeys() {
        return this.entityKeys;
    }

    @Override
    protected boolean nextStep(ResponseMessage message) throws IOException {
        if (message instanceof FindNodeResponse) {
            return this.handleNodeResponse((FindNodeResponse)message);
        }
        if (!(message instanceof FindValueResponse)) {
            throw new IllegalArgumentException("this is a find value handler");
        }
        FindValueResponse response = (FindValueResponse)message;
        if (!this.extractDataFromResponse(response)) {
            return false;
        }
        this.addToResponsePath(response);
        if (!this.exchaustive) {
            this.killActiveSearches();
            return false;
        }
        return true;
    }

    @Override
    protected int getDefaultParallelism() {
        return LookupSettings.FIND_VALUE_PARALLEL_LOOKUPS.getValue();
    }

    @Override
    protected boolean isTimeout(long time) {
        long lookupTimeout = LookupSettings.FIND_VALUE_LOOKUP_TIMEOUT.getValue();
        return lookupTimeout > 0L && time >= lookupTimeout;
    }

    @Override
    protected LookupRequest createLookupRequest(Contact node) {
        Set<KUID> noKeys = Collections.emptySet();
        return this.context.getMessageHelper().createFindValueRequest(node.getContactAddress(), this.lookupId, noKeys, this.lookupKey.getDHTValueType());
    }

    private boolean extractDataFromResponse(FindValueResponse response) {
        Contact sender = response.getContact();
        Collection<KUID> availableSecondaryKeys = response.getSecondaryKeys();
        Collection<? extends DHTValueEntity> entities = response.getDHTValueEntities();
        if (availableSecondaryKeys.isEmpty() && entities.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(sender + " returned neither keys nor values for " + this.lookupId);
            }
            return false;
        }
        Collection<? extends DHTValueEntity> filtered = DatabaseUtils.filter(this.lookupKey.getDHTValueType(), entities);
        if (filtered.isEmpty() && !entities.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(sender + " returned unrequested types of values for " + this.lookupId);
            }
            return false;
        }
        this.entities.addAll(filtered);
        for (KUID secondaryKey : availableSecondaryKeys) {
            EntityKey key = EntityKey.createEntityKey(sender, this.lookupId, secondaryKey, this.lookupKey.getDHTValueType());
            this.entityKeys.add(key);
        }
        return true;
    }
}

