/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class SwingSafePropertyChangeSupport
extends PropertyChangeSupport {
    public SwingSafePropertyChangeSupport(Object sourceBean) {
        super(sourceBean);
    }

    @Override
    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.unwrap(super.getPropertyChangeListeners());
    }

    @Override
    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.unwrap(super.getPropertyChangeListeners(propertyName));
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (EventQueue.isDispatchThread()) {
            listener = this.wrap(listener);
        }
        super.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (EventQueue.isDispatchThread()) {
            listener = this.wrap(listener);
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        listener = this.wrap(listener, super.getPropertyChangeListeners());
        super.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        listener = this.wrap(listener, super.getPropertyChangeListeners(propertyName));
        super.removePropertyChangeListener(propertyName, listener);
    }

    private PropertyChangeListener wrap(PropertyChangeListener toFind, PropertyChangeListener[] all) {
        for (PropertyChangeListener listener : all) {
            if (listener == toFind) {
                return listener;
            }
            if (!(listener instanceof SwingSafePropertyChangeListener) || ((SwingSafePropertyChangeListener)listener).delegate != toFind) continue;
            return listener;
        }
        return toFind;
    }

    private PropertyChangeListener wrap(PropertyChangeListener listener) {
        return new SwingSafePropertyChangeListener(listener);
    }

    private PropertyChangeListener[] unwrap(PropertyChangeListener[] propertyChangeListeners) {
        PropertyChangeListener[] newListeners = null;
        for (int i = 0; i < propertyChangeListeners.length; ++i) {
            PropertyChangeListener listener = propertyChangeListeners[i];
            if (!(listener instanceof SwingSafePropertyChangeListener)) continue;
            if (newListeners == null) {
                newListeners = new PropertyChangeListener[propertyChangeListeners.length];
                System.arraycopy(propertyChangeListeners, 0, newListeners, 0, newListeners.length);
            }
            newListeners[i] = ((SwingSafePropertyChangeListener)listener).delegate;
        }
        return newListeners == null ? propertyChangeListeners : newListeners;
    }

    private static class SwingSafePropertyChangeListener
    implements PropertyChangeListener {
        private final PropertyChangeListener delegate;

        public SwingSafePropertyChangeListener(PropertyChangeListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (EventQueue.isDispatchThread()) {
                this.delegate.propertyChange(evt);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingSafePropertyChangeListener.this.delegate.propertyChange(evt);
                    }
                });
            }
        }
    }
}

