/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.core.api.search.SearchManager;
import org.limewire.core.api.search.SearchResultList;
import org.limewire.core.impl.search.CoreSearchResultList;
import org.limewire.inject.LazySingleton;

@LazySingleton
public class CoreSearchManager
implements SearchManager {
    private final List<SearchResultList> threadSafeSearchList = new CopyOnWriteArrayList<SearchResultList>();

    @Inject
    public CoreSearchManager() {
    }

    @Override
    public SearchResultList addSearch(Search search, SearchDetails searchDetails) {
        CoreSearchResultList resultList = new CoreSearchResultList(search, searchDetails);
        this.threadSafeSearchList.add(resultList);
        return resultList;
    }

    @Override
    public void removeSearch(Search search) {
        for (SearchResultList resultList : this.threadSafeSearchList) {
            if (!search.equals(resultList.getSearch())) continue;
            resultList.dispose();
            this.threadSafeSearchList.remove(resultList);
            break;
        }
    }

    @Override
    public List<Search> getActiveSearches() {
        ArrayList<Search> list = new ArrayList<Search>();
        for (SearchResultList resultList : this.threadSafeSearchList) {
            if (resultList.getGuid() == null) continue;
            list.add(resultList.getSearch());
        }
        return list;
    }

    @Override
    public SearchResultList getSearchResultList(Search search) {
        for (SearchResultList resultList : this.threadSafeSearchList) {
            if (!search.equals(resultList.getSearch())) continue;
            return resultList;
        }
        return null;
    }
}

