/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.Serializable;
import org.limewire.collection.Range;
import org.limewire.util.ByteUtils;

public class LongInterval
extends Range
implements Serializable {
    private static final long serialVersionUID = -2562093104400487445L;
    private final long low;
    private final long high;

    protected LongInterval(long low, long high) {
        if (high < low) {
            throw new IllegalArgumentException("low: " + low + ", high: " + high);
        }
        if (low < 0L) {
            throw new IllegalArgumentException("low < min int:" + low);
        }
        if (high > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("high > max int:" + high);
        }
        this.low = low;
        this.high = high;
    }

    protected LongInterval(long singleton) {
        this(singleton, singleton);
    }

    @Override
    public final long getLow() {
        return this.low;
    }

    @Override
    public final long getHigh() {
        return this.high;
    }

    @Override
    public byte[] toBytes() {
        if (this.isLong()) {
            byte[] res = new byte[10];
            this.toBytes(res, 0);
            return res;
        }
        byte[] res = new byte[8];
        this.toBytes8(res, 0);
        return res;
    }

    @Override
    public void toBytes(byte[] dest, int offset) {
        if (!this.isLong()) {
            this.toBytes8(dest, offset);
            return;
        }
        dest[offset + 0] = (byte)(this.low >> 32);
        dest[offset + 1] = (byte)(this.low >> 24);
        dest[offset + 2] = (byte)(this.low >> 16);
        dest[offset + 3] = (byte)(this.low >> 8);
        dest[offset + 4] = (byte)this.low;
        dest[offset + 5] = (byte)(this.high >> 32);
        dest[offset + 6] = (byte)(this.high >> 24);
        dest[offset + 7] = (byte)(this.high >> 16);
        dest[offset + 8] = (byte)(this.high >> 8);
        dest[offset + 9] = (byte)this.high;
    }

    private void toBytes8(byte[] dest, int offset) {
        ByteUtils.int2beb((int)this.low, dest, offset);
        ByteUtils.int2beb((int)this.high, dest, offset + 4);
    }

    @Override
    public final boolean isLong() {
        return this.high > Integer.MAX_VALUE;
    }
}

