/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.SupportedFileFormat;
import org.jaudiotagger.audio.asf.tag.AsfTag;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.real.RealTag;
import org.jaudiotagger.audio.wav.WavTag;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class AudioFile {
    protected File file;
    protected AudioHeader audioHeader;
    protected Tag tag;

    public AudioFile() {
    }

    public AudioFile(File f, AudioHeader audioHeader, Tag tag) {
        this.file = f;
        this.audioHeader = audioHeader;
        this.tag = tag;
    }

    public AudioFile(String s, AudioHeader audioHeader, Tag tag) {
        this.file = new File(s);
        this.audioHeader = audioHeader;
        this.tag = tag;
    }

    public void commit() throws CannotWriteException {
        AudioFileIO.write(this);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public AudioHeader getAudioHeader() {
        return this.audioHeader;
    }

    public Tag getTag() {
        return this.tag;
    }

    public String toString() {
        return "AudioFile " + this.getFile().getAbsolutePath() + "  --------\n" + this.audioHeader.toString() + "\n" + (this.tag == null ? "" : ((Object)this.tag).toString()) + "\n-------------------";
    }

    protected RandomAccessFile checkFilePermissions(File file, boolean readOnly) throws ReadOnlyFileException, FileNotFoundException {
        RandomAccessFile newFile;
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to find:" + file.getPath());
        }
        if (readOnly) {
            newFile = new RandomAccessFile(file, "r");
        } else {
            if (!file.canWrite()) {
                throw new ReadOnlyFileException("Unable to write to:" + file.getPath());
            }
            newFile = new RandomAccessFile(file, "rw");
        }
        return newFile;
    }

    public String displayStructureAsXML() {
        return "";
    }

    public String displayStructureAsPlainText() {
        return "";
    }

    public Tag createDefaultTag() {
        if (SupportedFileFormat.FLAC.getFilesuffix().equals(this.file.getName().substring(this.file.getName().lastIndexOf(46)))) {
            return new FlacTag(VorbisCommentTag.createNewTag(), new ArrayList<MetadataBlockDataPicture>());
        }
        if (SupportedFileFormat.OGG.getFilesuffix().equals(this.file.getName().substring(this.file.getName().lastIndexOf(46)))) {
            return VorbisCommentTag.createNewTag();
        }
        if (SupportedFileFormat.MP4.getFilesuffix().equals(this.file.getName().substring(this.file.getName().lastIndexOf(46)))) {
            return new Mp4Tag();
        }
        if (SupportedFileFormat.M4A.getFilesuffix().equals(this.file.getName().substring(this.file.getName().lastIndexOf(46)))) {
            return new Mp4Tag();
        }
        if (SupportedFileFormat.M4P.getFilesuffix().equals(this.file.getName().substring(this.file.getName().lastIndexOf(46)))) {
            return new Mp4Tag();
        }
        if (SupportedFileFormat.WMA.getFilesuffix().equals(this.file.getName().substring(this.file.getName().lastIndexOf(46)))) {
            return new AsfTag();
        }
        if (SupportedFileFormat.WAV.getFilesuffix().equals(this.file.getName().substring(this.file.getName().lastIndexOf(46)))) {
            return new WavTag();
        }
        if (SupportedFileFormat.RA.getFilesuffix().equals(this.file.getName().substring(this.file.getName().lastIndexOf(46)))) {
            return new RealTag();
        }
        if (SupportedFileFormat.RM.getFilesuffix().equals(this.file.getName().substring(this.file.getName().lastIndexOf(46)))) {
            return new RealTag();
        }
        throw new RuntimeException("Unable to create default tag for this file format");
    }

    public Tag getTagOrCreateDefault() {
        Tag tag = this.getTag();
        if (tag == null) {
            return this.createDefaultTag();
        }
        return tag;
    }

    public Tag getTagOrCreateAndSetDefault() {
        Tag tag = this.getTag();
        if (tag == null) {
            tag = this.createDefaultTag();
            this.setTag(tag);
            return tag;
        }
        return tag;
    }

    public static String getBaseFilename(File file) {
        int index = file.getName().toLowerCase().lastIndexOf(".");
        if (index > 0) {
            return file.getName().substring(0, index);
        }
        return file.getName();
    }
}

