/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event.annotation;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceExistsException;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.annotation.BaseProxySubscriber;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.bushe.swing.event.annotation.EventTopicPatternSubscriber;
import org.bushe.swing.event.annotation.ProxyTopicPatternSubscriber;
import org.bushe.swing.event.annotation.ProxyTopicSubscriber;
import org.bushe.swing.event.annotation.UseTheClassOfTheAnnotatedMethodsParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessor {
    public static void process(Object object) {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            EventTopicPatternSubscriber eventTopicPatternSubscriber;
            org.bushe.swing.event.annotation.EventTopicSubscriber eventTopicSubscriber;
            Method method = methodArray[i];
            EventSubscriber eventSubscriber = method.getAnnotation(EventSubscriber.class);
            if (eventSubscriber != null) {
                AnnotationProcessor.process(eventSubscriber, object, method);
            }
            if ((eventTopicSubscriber = method.getAnnotation(org.bushe.swing.event.annotation.EventTopicSubscriber.class)) != null) {
                AnnotationProcessor.process(eventTopicSubscriber, object, method);
            }
            if ((eventTopicPatternSubscriber = method.getAnnotation(EventTopicPatternSubscriber.class)) == null) continue;
            AnnotationProcessor.process(eventTopicPatternSubscriber, object, method);
        }
    }

    private static void process(EventTopicPatternSubscriber eventTopicPatternSubscriber, Object object, Method method) {
        String string = eventTopicPatternSubscriber.topicPattern();
        if (string == null) {
            throw new IllegalArgumentException("Topic pattern cannot be null for EventTopicPatternSubscriber annotation");
        }
        Class<? extends EventService> clazz = eventTopicPatternSubscriber.autoCreateEventServiceClass();
        String string2 = eventTopicPatternSubscriber.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(string2, clazz);
        Pattern pattern = Pattern.compile(string);
        ProxyTopicPatternSubscriber proxyTopicPatternSubscriber = new ProxyTopicPatternSubscriber(object, method, eventTopicPatternSubscriber.referenceStrength(), eventService, string, pattern);
        eventService.subscribeStrongly(pattern, (EventTopicSubscriber)proxyTopicPatternSubscriber);
    }

    private static void process(org.bushe.swing.event.annotation.EventTopicSubscriber eventTopicSubscriber, Object object, Method method) {
        String string = eventTopicSubscriber.topic();
        if (string == null) {
            throw new IllegalArgumentException("Topic cannot be null for EventTopicSubscriber annotation");
        }
        Class<? extends EventService> clazz = eventTopicSubscriber.autoCreateEventServiceClass();
        String string2 = eventTopicSubscriber.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(string2, clazz);
        ProxyTopicSubscriber proxyTopicSubscriber = new ProxyTopicSubscriber(object, method, eventTopicSubscriber.referenceStrength(), eventService, string);
        eventService.subscribeStrongly(string, (EventTopicSubscriber)proxyTopicSubscriber);
    }

    private static void process(EventSubscriber eventSubscriber, Object object, Method method) {
        Object object2;
        Class<?> clazz = eventSubscriber.eventClass();
        if (clazz == null) {
            throw new IllegalArgumentException("Event class cannot be null for EventSubscriber annotation");
        }
        if (UseTheClassOfTheAnnotatedMethodsParameter.class.equals((Object)clazz)) {
            object2 = method.getParameterTypes();
            if (((Class<?>[])object2).length < 1) {
                throw new RuntimeException("Expected annotated method to have one parameter.");
            }
            clazz = object2[0];
        }
        object2 = eventSubscriber.autoCreateEventServiceClass();
        String string = eventSubscriber.eventServiceName();
        EventService eventService = AnnotationProcessor.getEventServiceFromAnnotation(string, object2);
        BaseProxySubscriber baseProxySubscriber = new BaseProxySubscriber(object, method, eventSubscriber.referenceStrength(), eventService, clazz);
        if (eventSubscriber.exact()) {
            eventService.subscribeExactlyStrongly(clazz, baseProxySubscriber);
        } else {
            eventService.subscribeStrongly(clazz, baseProxySubscriber);
        }
    }

    private static EventService getEventServiceFromAnnotation(String string, Class<? extends EventService> clazz) {
        EventService eventService = EventServiceLocator.getEventService(string);
        if (eventService == null) {
            if ("EventBus".equals(string)) {
                eventService = EventServiceLocator.getSwingEventService();
            } else {
                try {
                    eventService = clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException("Could not instance of create EventService class " + clazz, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Could not instance of create EventService class " + clazz, illegalAccessException);
                }
                try {
                    EventServiceLocator.setEventService(string, eventService);
                }
                catch (EventServiceExistsException eventServiceExistsException) {
                    eventService = EventServiceLocator.getEventService(string);
                }
            }
        }
        return eventService;
    }
}

