/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

public class RingBuffer {
    private Object[] buckets;
    private int readIndex;
    private int writeIndex;
    private int overrunCounter;

    private RingBuffer() {
    }

    public RingBuffer(int maxItems) {
        this.resize(maxItems);
    }

    public synchronized void resize(int maxItems) {
        if (maxItems < 1) {
            maxItems = 1;
        }
        this.buckets = new Object[maxItems + 1];
        this.overrunCounter = 0;
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public synchronized int size() {
        return this.buckets.length - 1;
    }

    public synchronized int getOverrunCounter() {
        return this.overrunCounter;
    }

    public synchronized boolean isEmpty() {
        return this.readIndex == this.writeIndex;
    }

    public synchronized boolean isFull() {
        int index = this.writeIndex + 1;
        if (index >= this.buckets.length) {
            index = 0;
        }
        return index == this.readIndex;
    }

    public synchronized boolean put(Object item) {
        boolean fBufferOverrun = false;
        if (this.isFull()) {
            try {
                this.get();
                fBufferOverrun = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.overrunCounter;
        }
        this.buckets[this.writeIndex++] = item;
        if (this.writeIndex >= this.buckets.length) {
            this.writeIndex = 0;
        }
        this.notifyAll();
        return fBufferOverrun;
    }

    public synchronized Object get() throws InterruptedException {
        if (this.isEmpty()) {
            this.wait();
        }
        Object item = this.buckets[this.readIndex++];
        if (this.readIndex >= this.buckets.length) {
            this.readIndex = 0;
        }
        return item;
    }

    public synchronized Object peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.buckets[this.readIndex];
    }
}

