/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RTPDestPanel
extends JPanel {
    private List<JLabel> trackNames = new ArrayList<JLabel>();
    private List<JTextField> textSessionAddresses = new ArrayList<JTextField>();
    private List<JTextField> textPorts = new ArrayList<JTextField>();
    private List<JComboBox> comboTTLs = new ArrayList<JComboBox>();
    private List<Integer> trackNumbers = new ArrayList<Integer>();
    private JLabel labelMessage;
    private JLabel labelPort;
    private JLabel labelSessionAddress;
    private JLabel labelTTL;
    private JLabel labelTrack;

    public RTPDestPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.labelMessage = new JLabel();
        this.labelTrack = new JLabel();
        this.labelSessionAddress = new JLabel();
        this.labelPort = new JLabel();
        this.labelTTL = new JLabel();
        this.setLayout(new GridBagLayout());
        this.labelMessage.setText("Enter the session address and port number for each track:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelMessage, gridBagConstraints);
        this.labelTrack.setText("Track:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelTrack, gridBagConstraints);
        this.labelSessionAddress.setText("Session address:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelSessionAddress, gridBagConstraints);
        this.labelPort.setText("Port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelPort, gridBagConstraints);
        this.labelTTL.setText("TTL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelTTL, gridBagConstraints);
    }

    public JTextField getTextSessionAddress(int index) {
        for (int i = 0; i < this.trackNumbers.size(); ++i) {
            Integer trackNum = this.trackNumbers.get(i);
            if (trackNum != index) continue;
            return this.textSessionAddresses.get(i);
        }
        throw new IllegalArgumentException();
    }

    public JTextField getTextPort(int index) {
        for (int i = 0; i < this.trackNumbers.size(); ++i) {
            Integer trackNum = this.trackNumbers.get(i);
            if (trackNum != index) continue;
            return this.textPorts.get(i);
        }
        throw new IllegalArgumentException();
    }

    public JComboBox getComboTTL(int index) {
        for (int i = 0; i < this.trackNumbers.size(); ++i) {
            Integer trackNum = this.trackNumbers.get(i);
            if (trackNum != index) continue;
            return this.comboTTLs.get(i);
        }
        throw new IllegalArgumentException();
    }

    public JLabel getLabelPort() {
        return this.labelPort;
    }

    public JLabel getLabelSessionAddress() {
        return this.labelSessionAddress;
    }

    public JLabel getLabelTTL() {
        return this.labelTTL;
    }

    public void addTrack(int trackNum, boolean audio) {
        JLabel trackName = new JLabel();
        JTextField textSessionAddress = new JTextField();
        JTextField textPort = new JTextField();
        JComboBox<String> comboTTL = new JComboBox<String>();
        trackName.setText((audio ? "Audio " : "Video ") + trackNum);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)trackName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)textSessionAddress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)textPort, gridBagConstraints);
        comboTTL.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "8", "16", "32", "64", "128", "255"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add(comboTTL, gridBagConstraints);
        this.trackNames.add(trackName);
        this.textSessionAddresses.add(textSessionAddress);
        this.textPorts.add(textPort);
        this.comboTTLs.add(comboTTL);
        this.trackNumbers.add(new Integer(trackNum));
    }
}

