/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.swing.DefaultComboBoxModel;
import net.sf.fmj.ui.wizard.WizardPanelDescriptor;
import net.sf.fmj.ui.wizards.ChooseSourcePanelDescriptor;
import net.sf.fmj.ui.wizards.ContentAndTrackFormatPanel;
import net.sf.fmj.ui.wizards.ContentDescriptorFilter;
import net.sf.fmj.ui.wizards.ProcessorWizardConfig;
import net.sf.fmj.ui.wizards.ProcessorWizardResult;
import net.sf.fmj.ui.wizards.TrackConfig;
import net.sf.fmj.ui.wizards.WizardStepException;
import net.sf.fmj.utility.LoggerSingleton;

public class ContentAndTrackFormatPanelDescriptor
extends WizardPanelDescriptor {
    private static final Logger logger = LoggerSingleton.logger;
    public static final String IDENTIFIER = ContentAndTrackFormatPanelDescriptor.class.getName();
    private final ContentAndTrackFormatPanel panel = new ContentAndTrackFormatPanel();
    private final ProcessorWizardConfig config;
    private final ProcessorWizardResult result;
    private final Object nextPanelDescriptor;
    private final ContentDescriptorFilter contentDescriptorFilter;
    private TrackConfig[] trackConfigs;

    public ContentAndTrackFormatPanelDescriptor(Object nextPanelDescriptor, ContentDescriptorFilter contentDescriptorFilter, ProcessorWizardConfig config, ProcessorWizardResult result) {
        this.setPanelDescriptorIdentifier(IDENTIFIER);
        this.setPanelComponent(this.panel);
        this.config = config;
        this.result = result;
        this.nextPanelDescriptor = nextPanelDescriptor;
        this.contentDescriptorFilter = contentDescriptorFilter;
    }

    public Object getNextPanelDescriptor() {
        return this.nextPanelDescriptor;
    }

    public Object getBackPanelDescriptor() {
        return ChooseSourcePanelDescriptor.IDENTIFIER;
    }

    public ContentAndTrackFormatPanel getContentAndTrackFormatPanel() {
        return (ContentAndTrackFormatPanel)this.getPanelComponent();
    }

    private boolean isCompatible(ContentDescriptor d) {
        return this.contentDescriptorFilter.isCompatible(d);
    }

    private ContentDescriptor[] compatible(ContentDescriptor[] contentDescriptors) {
        ArrayList<ContentDescriptor> result = new ArrayList<ContentDescriptor>();
        for (int i = 0; i < contentDescriptors.length; ++i) {
            if (!this.isCompatible(contentDescriptors[i])) continue;
            result.add(contentDescriptors[i]);
        }
        ContentDescriptor[] arrayResult = new ContentDescriptor[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            arrayResult[i] = (ContentDescriptor)result.get(i);
        }
        return arrayResult;
    }

    public boolean aboutToDisplayPanel(Object prevId) {
        if (prevId == this.getBackPanelDescriptor()) {
            int i;
            ContentDescriptor[] contentDescriptors = this.result.processor.getSupportedContentDescriptors();
            if (contentDescriptors.length == 0) {
                this.showError("Processor supports no content descriptors");
                return false;
            }
            if ((contentDescriptors = this.compatible(contentDescriptors)).length == 0) {
                this.showError("Processor supports no compatible content descriptors");
                return false;
            }
            this.getContentAndTrackFormatPanel().getComboFormat().setModel(new DefaultComboBoxModel<ContentDescriptor>(contentDescriptors));
            int contentDescriptorIndexToSet = 0;
            if (this.config.contentDescriptor != null) {
                for (int i2 = 0; i2 < contentDescriptors.length; ++i2) {
                    if (!this.config.contentDescriptor.equals(contentDescriptors[i2])) continue;
                    contentDescriptorIndexToSet = i2;
                    break;
                }
            }
            this.config.contentDescriptor = contentDescriptors[contentDescriptorIndexToSet];
            this.getContentAndTrackFormatPanel().getComboFormat().setSelectedItem(this.config.contentDescriptor);
            try {
                this.result.step2_setContentDescriptor(this.config);
            }
            catch (WizardStepException e) {
                this.showError(e);
                return false;
            }
            TrackControl[] trackControls = this.result.processor.getTrackControls();
            if (trackControls == null || trackControls.length < 1) {
                this.showError("No tracks available");
                return false;
            }
            this.trackConfigs = new TrackConfig[trackControls.length];
            for (i = 0; i < this.trackConfigs.length; ++i) {
                this.trackConfigs[i] = new TrackConfig();
            }
            for (i = 0; i < trackControls.length; ++i) {
                Format[] formats = trackControls[i].getSupportedFormats();
                if (formats == null) {
                    logger.warning("No supported formats (formats=null) for track " + i);
                    this.trackConfigs[i].enabled = false;
                    this.trackConfigs[i].format = null;
                    continue;
                }
                if (formats.length == 0) {
                    logger.warning("No supported formats (formats.length=0) for track " + i);
                    this.trackConfigs[i].enabled = false;
                    this.trackConfigs[i].format = null;
                    continue;
                }
                for (int j = 0; j < formats.length; ++j) {
                    logger.info("Available track format: " + formats[j]);
                }
                this.getContentAndTrackFormatPanel().getAudioFormatPanel().getComboAudioEncoding().setModel(new DefaultComboBoxModel<String>(new String[]{"ULAW/rtp"}));
                this.getContentAndTrackFormatPanel().getAudioFormatPanel().getComboAudioSampleRate().setModel(new DefaultComboBoxModel<String>(new String[]{"8000"}));
                if (this.config.trackConfigs != null && this.config.trackConfigs.length >= i + 1 && this.config.trackConfigs[i].format instanceof AudioFormat) {
                    this.trackConfigs[i].format = this.config.trackConfigs[i].format;
                    this.trackConfigs[i].enabled = this.config.trackConfigs[i].enabled;
                } else {
                    this.trackConfigs[i].format = new AudioFormat("ULAW/rtp", 8000.0, 8, 1, 0, 1);
                    this.trackConfigs[i].enabled = trackControls[i].isEnabled();
                }
                boolean formatOk = false;
                for (int j = 0; j < formats.length; ++j) {
                    logger.fine("Track " + i + " supports format " + formats[j]);
                    if (!formats[j].matches(this.trackConfigs[i].format)) continue;
                    this.getContentAndTrackFormatPanel().addTrack(i, this.trackConfigs[i].enabled, (AudioFormat)this.trackConfigs[i].format);
                    formatOk = true;
                    break;
                }
                if (formatOk) continue;
                this.trackConfigs[i].enabled = false;
                this.trackConfigs[i].format = null;
            }
        }
        return true;
    }

    public boolean aboutToHidePanel(Object idOfNext) {
        if (idOfNext == this.getNextPanelDescriptor()) {
            for (int i = 0; i < this.trackConfigs.length; ++i) {
                this.trackConfigs[i].enabled = this.getContentAndTrackFormatPanel().getTrackControlPanel(i).getCheckBoxEnableTrack().isSelected();
                if (!this.trackConfigs[i].enabled) continue;
                this.trackConfigs[i].format = this.getContentAndTrackFormatPanel().getTrackControlPanel(i).getAudioFormatPanel().getAudioFormat();
            }
            try {
                this.config.trackConfigs = this.trackConfigs;
                this.result.step3_setTrackConfigs(this.config);
            }
            catch (WizardStepException e) {
                this.showError(e);
                return false;
            }
            return true;
        }
        return super.aboutToHidePanel(idOfNext);
    }
}

