/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import javax.media.protocol.PushSourceStream;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.SessionAddress;
import memetic.crypto.EncryptedRTPSocket;
import memetic.crypto.RTPCrypt;
import net.sf.fmj.media.rtp.SimpleSocketInputStream;
import net.sf.fmj.media.rtp.SocketOutputStream;

public class RTPSocketAdapter
implements RTPConnector {
    private EncryptedRTPSocket dataSock;
    private EncryptedRTPSocket ctrlSock;
    private InetAddress addr;
    private int port;
    private SimpleSocketInputStream dataInStrm = null;
    private SimpleSocketInputStream ctrlInStrm = null;
    private SocketOutputStream dataOutStrm = null;
    private SocketOutputStream ctrlOutStrm = null;

    public RTPSocketAdapter(InetAddress addr, int port) throws IOException {
        this(addr, port, 1);
    }

    public RTPSocketAdapter(InetAddress addr, int port, int ttl) throws IOException {
        try {
            if (addr.isMulticastAddress()) {
                this.dataSock = new EncryptedRTPSocket(null, port);
                this.ctrlSock = new EncryptedRTPSocket(null, port + 1);
                this.dataSock.joinGroup(addr);
                this.dataSock.setTimeToLive(ttl);
                this.dataSock.setLoopbackMode(false);
                this.ctrlSock.joinGroup(addr);
                this.ctrlSock.setTimeToLive(ttl);
                this.ctrlSock.setLoopbackMode(false);
            } else {
                this.dataSock = new EncryptedRTPSocket(null, port);
                this.ctrlSock = new EncryptedRTPSocket(null, port + 1);
            }
        }
        catch (SocketException e) {
            throw new IOException(e.getMessage());
        }
        this.addr = addr;
        this.port = port;
    }

    public void setEncryption(RTPCrypt crypter) {
        this.dataSock.setEncryption(crypter);
        this.ctrlSock.setEncryption(crypter);
    }

    public PushSourceStream getDataInputStream() {
        if (this.dataInStrm == null) {
            this.dataInStrm = new SimpleSocketInputStream(this.dataSock);
            this.dataInStrm.setName("SimpleSocketInputStream [data], port " + this.port);
            this.dataInStrm.start();
        }
        return this.dataInStrm;
    }

    public void addTarget(SessionAddress target) {
        if (this.ctrlOutStrm == null) {
            this.ctrlOutStrm = new SocketOutputStream(this.ctrlSock);
        }
        this.ctrlOutStrm.addTarget(target.getControlAddress(), target.getControlPort());
        if (this.dataOutStrm == null) {
            this.dataOutStrm = new SocketOutputStream(this.dataSock);
        }
        this.dataOutStrm.addTarget(target.getDataAddress(), target.getDataPort());
    }

    public OutputDataStream getDataOutputStream() {
        if (this.dataOutStrm == null) {
            this.dataOutStrm = new SocketOutputStream(this.dataSock);
        }
        return this.dataOutStrm;
    }

    public PushSourceStream getControlInputStream() {
        if (this.ctrlInStrm == null) {
            this.ctrlInStrm = new SimpleSocketInputStream(this.ctrlSock);
            this.ctrlInStrm.setName("SimpleSocketInputStream [ctrl], port " + (this.port + 1));
            this.ctrlInStrm.start();
        }
        return this.ctrlInStrm;
    }

    public OutputDataStream getControlOutputStream() {
        if (this.ctrlOutStrm == null) {
            this.ctrlOutStrm = new SocketOutputStream(this.ctrlSock);
        }
        return this.ctrlOutStrm;
    }

    public void close() {
        if (this.dataInStrm != null) {
            this.dataInStrm.kill();
        }
        if (this.ctrlInStrm != null) {
            this.ctrlInStrm.kill();
        }
        this.dataSock.close();
        this.ctrlSock.close();
    }

    public boolean removeTarget(SessionAddress target) {
        boolean ok = true;
        if (this.ctrlOutStrm != null) {
            ok &= this.ctrlOutStrm.removeTarget(target.getControlAddress(), target.getControlPort());
        }
        if (this.dataOutStrm != null) {
            ok &= this.dataOutStrm.removeTarget(target.getDataAddress(), target.getDataPort());
        }
        return ok;
    }

    public void removeTargets() {
        if (this.ctrlOutStrm != null) {
            this.ctrlOutStrm.removeTargets();
        }
        if (this.dataOutStrm != null) {
            this.dataOutStrm.removeTargets();
        }
    }

    public void setReceiveBufferSize(int size) throws IOException {
        this.dataSock.setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() {
        try {
            return this.dataSock.getReceiveBufferSize();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setSendBufferSize(int size) throws IOException {
        this.dataSock.setSendBufferSize(size);
    }

    public int getSendBufferSize() {
        try {
            return this.dataSock.getSendBufferSize();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public double getRTCPBandwidthFraction() {
        return -1.0;
    }

    public double getRTCPSenderBandwidthFraction() {
        return -1.0;
    }
}

