/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph.model;

import com.lti.utils.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.media.Format;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.fmj.filtergraph.model.FilterGraphModel;
import net.sf.fmj.filtergraph.model.FilterGraphModelIOException;
import net.sf.fmj.filtergraph.model.LinkModel;
import net.sf.fmj.filtergraph.model.NodeModel;
import net.sf.fmj.utility.FormatArgUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterGraphModelIO {
    private FilterGraphModelIO() {
    }

    public static void write(FilterGraphModel g, OutputStream os) throws IOException {
        os.write("<?xml version='1.0' encoding='utf-8'?>\n".getBytes());
        os.write("<FilterGraph version=\"1.0\">\n".getBytes());
        FilterGraphModelIO.write(g.getRoot(), -1, -1, null, os, 1);
        os.write("</FilterGraph>\n".getBytes());
    }

    private static String tabs(int i) {
        StringBuilder b = new StringBuilder();
        for (int j = 0; j < i; ++j) {
            b.append('\t');
        }
        return b.toString();
    }

    private static void write(String s, OutputStream os) throws IOException {
        os.write(s.getBytes());
    }

    private static void writeln(String s, OutputStream os, int depth) throws IOException {
        FilterGraphModelIO.write(FilterGraphModelIO.tabs(depth) + s + "\n", os);
    }

    private static void write(NodeModel n, int sourceTrack, int destTrack, Format destFormat, OutputStream os, int depth) throws IOException {
        String sourceTrackAttr = sourceTrack != -1 ? " sourceTrack=\"" + sourceTrack + "\"" : "";
        String destTrackAttr = destTrack != -1 ? " destTrack=\"" + destTrack + "\"" : "";
        String destTrackFormatAttr = destFormat != null ? " destFormat=\"" + StringUtils.replaceSpecialXMLChars(FormatArgUtils.toString(destFormat)) + "\"" : "";
        String nodeName = FilterGraphModelIO.getNodeName(n.getPlugInType());
        boolean oneLiner = n.getNumDestLinks() == 0;
        FilterGraphModelIO.writeln("<" + nodeName + " class=\"" + n.getPlugInClassName() + "\"" + sourceTrackAttr + destTrackAttr + destTrackFormatAttr + (oneLiner ? "/>" : ">"), os, depth);
        for (int i = 0; i < n.getNumDestLinks(); ++i) {
            LinkModel link = n.getDestLink(i);
            FilterGraphModelIO.write(link.getDestNode(), link.getSourceTrack(), link.getDestTrack(), link.getDestFormat(), os, depth + 1);
        }
        if (!oneLiner) {
            FilterGraphModelIO.writeln("</" + nodeName + ">", os, depth);
        }
    }

    public static final FilterGraphModel read(InputStream is) throws IOException, ParserConfigurationException, SAXException, FilterGraphModelIOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(is);
        return FilterGraphModelIO.parseFilterGraph(dom);
    }

    private static final FilterGraphModel parseFilterGraph(Document dom) throws FilterGraphModelIOException {
        Element filterGraphElt = dom.getDocumentElement();
        if (!filterGraphElt.getNodeName().equals("FilterGraph")) {
            throw new FilterGraphModelIOException("Expected root element to be FilterGraph");
        }
        String version = filterGraphElt.getAttribute("version");
        if (version == null || !version.equals("1.0")) {
            throw new FilterGraphModelIOException("Expected version 1.0: " + version);
        }
        List<Element> childElements = FilterGraphModelIO.getChildElements(filterGraphElt);
        if (childElements.size() != 1) {
            throw new FilterGraphModelIOException("Expected one and only one child of FilterGraph element");
        }
        return new FilterGraphModel(FilterGraphModelIO.parseRootNode(childElements.get(0)));
    }

    private static final List<Element> getChildElements(Element elt) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < elt.getChildNodes().getLength(); ++i) {
            if (!(elt.getChildNodes().item(i) instanceof Element)) continue;
            result.add((Element)elt.getChildNodes().item(i));
        }
        return result;
    }

    private static final NodeModel parseRootNode(Element elt) throws FilterGraphModelIOException {
        int plugInType = FilterGraphModelIO.getPlugInType(elt.getNodeName());
        if (plugInType < 0) {
            throw new FilterGraphModelIOException("Unknown plug-in node name: " + elt.getNodeName());
        }
        String plugInClassName = FilterGraphModelIO.getRequiredStringAttribute(elt, "class");
        NodeModel result = new NodeModel(plugInType, plugInClassName);
        List<Element> childElements = FilterGraphModelIO.getChildElements(elt);
        for (Element child : childElements) {
            LinkModel link = FilterGraphModelIO.parseLink(child);
            result.addDestLink(link);
        }
        return result;
    }

    private static final LinkModel parseLink(Element elt) throws FilterGraphModelIOException {
        Format destFormat;
        int plugInType = FilterGraphModelIO.getPlugInType(elt.getNodeName());
        if (plugInType < 0) {
            throw new FilterGraphModelIOException("Unknown plug-in node name: " + elt.getNodeName());
        }
        String plugInClassName = FilterGraphModelIO.getRequiredStringAttribute(elt, "class");
        int sourceTrack = FilterGraphModelIO.getIntAttribute(elt, "sourceTrack", -1);
        int destTrack = FilterGraphModelIO.getIntAttribute(elt, "destTrack", -1);
        String destFormatStr = FilterGraphModelIO.getRequiredStringAttribute(elt, "destFormat");
        try {
            destFormat = FormatArgUtils.parse(destFormatStr);
        }
        catch (ParseException e) {
            throw new FilterGraphModelIOException("Invalid format: " + destFormatStr, e);
        }
        NodeModel destNode = new NodeModel(plugInType, plugInClassName);
        List<Element> childElements = FilterGraphModelIO.getChildElements(elt);
        for (Element child : childElements) {
            LinkModel link = FilterGraphModelIO.parseLink(child);
            destNode.addDestLink(link);
        }
        LinkModel result = new LinkModel(sourceTrack, destTrack, destFormat, destNode);
        return result;
    }

    private static final String getRequiredStringAttribute(Element elt, String attrName) throws FilterGraphModelIOException {
        String result = elt.getAttribute(attrName);
        if (result == null || result.equals("")) {
            throw new FilterGraphModelIOException("Missing attribute: " + attrName);
        }
        return result;
    }

    private static final int getIntAttribute(Element elt, String attrName, int defaultResult) throws FilterGraphModelIOException {
        String attrValue = elt.getAttribute(attrName);
        if (attrValue == null || attrValue.equals("")) {
            return defaultResult;
        }
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new FilterGraphModelIOException("Expected integer: " + attrValue, e);
        }
    }

    private static final String getNodeName(int plugInType) {
        switch (plugInType) {
            case 1: {
                return "Demux";
            }
            case 2: {
                return "Codec";
            }
            case 3: {
                return "Effect";
            }
            case 4: {
                return "Renderer";
            }
            case 5: {
                return "Mux";
            }
        }
        throw new IllegalArgumentException();
    }

    private static final int getPlugInType(String nodeName) {
        for (int i = 1; i <= 5; ++i) {
            if (!nodeName.equals(FilterGraphModelIO.getNodeName(i))) continue;
            return i;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        FilterGraphModel m = FilterGraphModelIO.read(new FileInputStream("test.xml"));
        FilterGraphModelIO.write(m, (OutputStream)System.out);
    }
}

