/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls.skins.ejmf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import net.sf.fmj.ejmf.toolkit.gui.controls.skins.ejmf.BasicControlButton;

public class BasicArrowButton
extends BasicControlButton {
    protected int direction;

    public BasicArrowButton(int direction) {
        this.setDirection(direction);
        this.setBackground(UIManager.getColor("control"));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }

    protected void paintIcon(Graphics g, int x, int y, int size, boolean isEnabled) {
    }

    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color origColor = g.getColor();
        boolean isPressed = this.getModel().isPressed();
        boolean isEnabled = this.isEnabled();
        g.setColor(this.getBackground());
        g.fillRect(1, 1, w - 2, h - 2);
        if (isPressed) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawRect(0, 0, w - 1, h - 1);
        } else {
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 2, 0);
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawLine(1, 1, 1, h - 3);
            g.drawLine(2, 1, w - 3, 1);
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 1, w - 2, h - 3);
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, h - 1, w - 1, 0);
        }
        if (h < 5 || w < 5) {
            g.setColor(origColor);
            return;
        }
        if (isPressed) {
            g.translate(1, 1);
        }
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2);
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
        if (isPressed) {
            g.translate(-1, -1);
        }
        g.setColor(origColor);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Color oldColor = g.getColor();
        int j = 0;
        size = Math.max(size, 2);
        int mid = size / 2;
        g.translate(x, y);
        if (isEnabled) {
            g.setColor(UIManager.getColor("controlDkShadow"));
        } else {
            g.setColor(UIManager.getColor("controlShadow"));
        }
        switch (direction) {
            case 1: {
                int i;
                for (i = 0; i < size; ++i) {
                    g.drawLine(mid - i, i, mid + i, i);
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlHighlight"));
                g.drawLine(mid - i + 2, i, mid + i, i);
                break;
            }
            case 5: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlHighlight"));
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                int i;
                for (i = 0; i < size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlHighlight"));
                g.drawLine(i, mid - i + 2, i, mid + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlHighlight"));
                    for (i = size - 1; i >= 0; --i) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

