/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class ProcessorModel {
    private MediaLocator inputLocator;
    private Format[] formats;
    private ContentDescriptor outputContentDescriptor;
    private DataSource inputDataSource;

    public ProcessorModel() {
    }

    public ProcessorModel(Format[] formats, ContentDescriptor outputContentDescriptor) {
        this.formats = formats;
        this.outputContentDescriptor = outputContentDescriptor;
    }

    public ProcessorModel(DataSource inputDataSource, Format[] formats, ContentDescriptor outputContentDescriptor) {
        this.inputDataSource = inputDataSource;
        this.formats = formats;
        this.outputContentDescriptor = outputContentDescriptor;
    }

    public ProcessorModel(MediaLocator inputLocator, Format[] formats, ContentDescriptor outputContentDescriptor) {
        this.inputLocator = inputLocator;
        this.formats = formats;
        this.outputContentDescriptor = outputContentDescriptor;
    }

    public int getTrackCount(int availableTrackCount) {
        if (this.formats == null) {
            return -1;
        }
        return this.formats.length;
    }

    public Format getOutputTrackFormat(int tIndex) {
        if (this.formats == null) {
            return null;
        }
        if (tIndex < 0 || tIndex >= this.formats.length) {
            return null;
        }
        return this.formats[tIndex];
    }

    public boolean isFormatAcceptable(int tIndex, Format tFormat) {
        if (this.formats == null) {
            return true;
        }
        if (tIndex < 0 || tIndex >= this.formats.length) {
            return true;
        }
        return tFormat.matches(this.formats[tIndex]);
    }

    public ContentDescriptor getContentDescriptor() {
        return this.outputContentDescriptor;
    }

    public DataSource getInputDataSource() {
        return this.inputDataSource;
    }

    public MediaLocator getInputLocator() {
        return this.inputLocator;
    }
}

