/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.Txn;
import java.util.Timer;
import java.util.TimerTask;

public class AutoCommitTransaction
extends Transaction {
    public static final long TIMEOUT = 10000L;
    public static final int ENFORCE_COMMIT = 100;
    protected Timer timer;
    protected TimerTask commitTask;
    protected Transaction transaction;
    protected long touched = 0L;
    protected int txnCounter = 0;
    protected long timeout;
    protected int enforceCommit;

    public AutoCommitTransaction(Library library) {
        this(library, 10000L, 100);
    }

    public AutoCommitTransaction(Library library, long timeout, int enforceCommit) {
        super(library);
        this.timeout = timeout;
        this.enforceCommit = enforceCommit;
    }

    public int getEnforceCommit() {
        return this.enforceCommit;
    }

    public synchronized void setEnforceCommit(int enforceCommit) {
        this.enforceCommit = enforceCommit;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private synchronized void createTransactionIfNecessary() {
        this.touch();
        if (this.transaction == null) {
            this.transaction = this.library.beginTransaction();
            if (this.timer == null) {
                this.timer = new Timer();
            }
            if (this.commitTask == null) {
                this.commitTask = new CommitTask();
                this.timer.scheduleAtFixedRate(this.commitTask, 1000L, 500L);
            }
        }
    }

    protected synchronized void addTxn(Object obj, Txn txn) {
        this.createTransactionIfNecessary();
        this.transaction.addTxn(obj, txn);
        if (this.enforceCommit > 0) {
            ++this.txnCounter;
            if (this.txnCounter >= this.enforceCommit) {
                this.commit();
            }
        }
    }

    protected synchronized void attach(Object obj) {
        this.createTransactionIfNecessary();
        this.transaction.attach(obj);
    }

    protected synchronized boolean modified(Database database) {
        this.createTransactionIfNecessary();
        return this.transaction.modified(database);
    }

    protected synchronized boolean modified(Library library) {
        this.createTransactionIfNecessary();
        return this.transaction.modified(library);
    }

    protected synchronized boolean modified(Playlist playlist) {
        this.createTransactionIfNecessary();
        return this.transaction.modified(playlist);
    }

    protected synchronized boolean modified(Song song) {
        this.createTransactionIfNecessary();
        return this.transaction.modified(song);
    }

    public synchronized void commit() {
        if (this.transaction != null) {
            this.transaction.commit();
            this.commitTask.cancel();
            this.timer.cancel();
            this.transaction = null;
            this.commitTask = null;
            this.timer = null;
            this.txnCounter = 0;
            this.touched = 0L;
        }
    }

    public synchronized void rollback() {
        if (this.transaction != null) {
            this.transaction.rollback();
            this.commitTask.cancel();
            this.timer.cancel();
            this.transaction = null;
            this.commitTask = null;
            this.timer = null;
            this.txnCounter = 0;
            this.touched = 0L;
        }
    }

    protected synchronized void touch() {
        this.touched = System.currentTimeMillis();
    }

    private class CommitTask
    extends TimerTask {
        private CommitTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AutoCommitTransaction autoCommitTransaction = AutoCommitTransaction.this;
            synchronized (autoCommitTransaction) {
                if (System.currentTimeMillis() - AutoCommitTransaction.this.touched >= AutoCommitTransaction.this.timeout) {
                    AutoCommitTransaction.this.commit();
                }
            }
        }
    }
}

