/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import org.limewire.inspection.InspectionPoint;
import org.limewire.statistic.BasicKilobytesStatistic;
import org.limewire.statistic.Statistic;
import org.limewire.statistic.StatisticAccumulator;

@Singleton
class TcpBandwidthStatisticsImpl
implements TcpBandwidthStatistics {
    private final StatisticAccumulator statisticAccumulator;
    @InspectionPoint(value="tcp upstream")
    private final Statistic UPSTREAM;
    @InspectionPoint(value="tcp downstream")
    private final Statistic DOWNSTREAM;
    @InspectionPoint(value="http downstream")
    private final Statistic HTTP_DOWNSTREAM;
    @InspectionPoint(value="http upstream")
    private final Statistic HTTP_UPSTREAM;
    @InspectionPoint(value="http downstream innetwork")
    private final Statistic HTTP_DOWNSTREAM_INNETWORK;
    @InspectionPoint(value="http upstream innetwork")
    private final Statistic HTTP_UPSTREAM_INNETWORK;
    @InspectionPoint(value="http header downstream")
    private final Statistic HTTP_HEADER_DOWNSTREAM;
    @InspectionPoint(value="http header downstream innetwork")
    private final Statistic HTTP_HEADER_DOWNSTREAM_INNETWORK;
    @InspectionPoint(value="http body downstream")
    private final Statistic HTTP_BODY_DOWNSTREAM;
    @InspectionPoint(value="http body downstream innetwork")
    private final Statistic HTTP_BODY_DOWNSTREAM_INNETWORK;
    @InspectionPoint(value="http header upstream")
    private final Statistic HTTP_HEADER_UPSTREAM;
    @InspectionPoint(value="http header upstream innetwork")
    private final Statistic HTTP_HEADER_UPSTREAM_INNETWORK;
    @InspectionPoint(value="http body upstream")
    private final Statistic HTTP_BODY_UPSTREAM;
    @InspectionPoint(value="http body upstream innetwork")
    private final Statistic HTTP_BODY_UPSTREAM_INNETWORK;

    @Inject
    TcpBandwidthStatisticsImpl(StatisticAccumulator statisticAccumulator) {
        this.statisticAccumulator = statisticAccumulator;
        this.UPSTREAM = new BandwidthStat();
        this.DOWNSTREAM = new BandwidthStat();
        this.HTTP_DOWNSTREAM = new DelegateStat(this.DOWNSTREAM);
        this.HTTP_UPSTREAM = new DelegateStat(this.UPSTREAM);
        this.HTTP_DOWNSTREAM_INNETWORK = new DelegateStat(this.DOWNSTREAM);
        this.HTTP_UPSTREAM_INNETWORK = new DelegateStat(this.UPSTREAM);
        this.HTTP_HEADER_DOWNSTREAM_INNETWORK = new DelegateStat(this.HTTP_DOWNSTREAM_INNETWORK);
        this.HTTP_BODY_DOWNSTREAM_INNETWORK = new DelegateStat(this.HTTP_DOWNSTREAM_INNETWORK);
        this.HTTP_HEADER_UPSTREAM_INNETWORK = new DelegateStat(this.HTTP_UPSTREAM_INNETWORK);
        this.HTTP_BODY_UPSTREAM_INNETWORK = new DelegateStat(this.HTTP_UPSTREAM_INNETWORK);
        this.HTTP_HEADER_DOWNSTREAM = new DelegateStat(this.HTTP_DOWNSTREAM);
        this.HTTP_BODY_DOWNSTREAM = new DelegateStat(this.HTTP_DOWNSTREAM);
        this.HTTP_HEADER_UPSTREAM = new DelegateStat(this.HTTP_UPSTREAM);
        this.HTTP_BODY_UPSTREAM = new DelegateStat(this.HTTP_UPSTREAM);
    }

    @Override
    public Statistic getStatistic(TcpBandwidthStatistics.StatisticType statisticType) {
        switch (statisticType) {
            case HTTP_BODY_DOWNSTREAM: {
                return this.HTTP_BODY_DOWNSTREAM;
            }
            case HTTP_BODY_INNETWORK_DOWNSTREAM: {
                return this.HTTP_BODY_DOWNSTREAM_INNETWORK;
            }
            case HTTP_BODY_INNETWORK_UPSTREAM: {
                return this.HTTP_BODY_UPSTREAM_INNETWORK;
            }
            case HTTP_BODY_UPSTREAM: {
                return this.HTTP_BODY_UPSTREAM;
            }
            case HTTP_HEADER_DOWNSTREAM: {
                return this.HTTP_HEADER_DOWNSTREAM;
            }
            case HTTP_HEADER_INNETWORK_DOWNSTREAM: {
                return this.HTTP_HEADER_DOWNSTREAM_INNETWORK;
            }
            case HTTP_HEADER_INNETWORK_UPSTREAM: {
                return this.HTTP_HEADER_UPSTREAM_INNETWORK;
            }
            case HTTP_HEADER_UPSTREAM: {
                return this.HTTP_HEADER_UPSTREAM;
            }
        }
        throw new IllegalArgumentException("invalid statistic type: " + (Object)((Object)statisticType));
    }

    @Override
    public long getTotalDownstream() {
        return (long)this.DOWNSTREAM.getTotal();
    }

    @Override
    public long getTotalUpstream() {
        return (long)this.UPSTREAM.getTotal();
    }

    @Override
    public double getAverageHttpUpstream() {
        return this.HTTP_UPSTREAM.getAverage();
    }

    private class DelegateStat
    extends BandwidthStat {
        private final Statistic delegate;

        DelegateStat(Statistic delegate) {
            this.delegate = delegate;
        }

        @Override
        public void addData(int data) {
            super.addData(data);
            this.delegate.addData(data);
        }
    }

    private class BandwidthStat
    extends BasicKilobytesStatistic {
        public BandwidthStat() {
            super(TcpBandwidthStatisticsImpl.this.statisticAccumulator);
        }
    }
}

