/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.security.Certificate;
import com.limegroup.gnutella.security.CertificateImpl;
import com.limegroup.gnutella.security.CertificateParser;
import java.io.IOException;
import java.security.PublicKey;
import org.limewire.security.SignatureVerifier;
import org.limewire.util.Base32;
import org.limewire.util.StringUtils;

public class CertificateParserImpl
implements CertificateParser {
    @Override
    public Certificate parseCertificate(String contents) throws IOException {
        int keyVersion;
        String[] parts = contents.split("\\|");
        if (parts.length != 3) {
            throw new IOException(parts.length + " invalid data format: " + contents);
        }
        byte[] signature = Base32.decode(parts[0]);
        byte[] signedPayload = CertificateParserImpl.extractSignedPayload(contents);
        try {
            keyVersion = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Could not parse key version");
        }
        PublicKey publicKey = SignatureVerifier.readKey(parts[2], "DSA");
        if (publicKey == null) {
            throw new IOException("invalid public key");
        }
        return new CertificateImpl(signature, signedPayload, keyVersion, publicKey, contents);
    }

    static byte[] extractSignedPayload(String contents) throws IOException {
        int pipe = contents.indexOf(124);
        if (pipe < 0 || pipe == contents.length() - 1) {
            throw new IOException("invalid contents: " + contents);
        }
        return StringUtils.toUTF8Bytes(contents.substring(pipe + 1));
    }
}

