/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.routing.QRTTableStorage;
import java.util.Iterator;
import org.limewire.collection.SparseIntSet;

class SparseSetStorage
implements QRTTableStorage {
    private final SparseIntSet set;
    private final int length;

    SparseSetStorage(int length) {
        this(new SparseIntSet(), length);
    }

    private SparseSetStorage(SparseIntSet set, int length) {
        this.set = set;
        this.length = length;
    }

    @Override
    public void clear(int hash) {
        this.set.remove(hash);
    }

    @Override
    public void compact() {
        this.set.compact();
    }

    @Override
    public double getPercentFull() {
        return (double)this.set.size() * 100.0 / (double)this.length;
    }

    @Override
    public int getUnitsInUse() {
        return this.set.getActualMemoryUsed() / 8;
    }

    @Override
    public int getUnusedUnits() {
        return 0;
    }

    @Override
    public int numUnitsWithLoad(int load) {
        return -1;
    }

    @Override
    public void or(QRTTableStorage other) {
        if (other instanceof SparseSetStorage) {
            SparseSetStorage optimized = (SparseSetStorage)other;
            this.set.addAll(optimized.set);
        } else {
            Iterator i$ = other.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                this.set.add(i);
            }
        }
    }

    @Override
    public QRTTableStorage resize(int newSize) {
        if (newSize == this.length) {
            return this;
        }
        SparseIntSet s = new SparseIntSet();
        for (int i : this.set) {
            int firstSet = (int)((long)i * (long)newSize / (long)this.length);
            i = this.nextClearBit(i + 1);
            int lastNotSet = (int)(((long)i * (long)newSize - 1L) / (long)this.length + 1L);
            for (int j = firstSet; j < lastNotSet; ++j) {
                s.add(j);
            }
        }
        return new SparseSetStorage(s, newSize);
    }

    @Override
    public void set(int hash) {
        this.set.add(hash);
    }

    @Override
    public void xor(QRTTableStorage other) {
        for (int i = 0; i < this.length; ++i) {
            if (this.get(i) != other.get(i)) {
                this.set(i);
                continue;
            }
            this.clear(i);
        }
    }

    @Override
    public int cardinality() {
        return this.set.size();
    }

    @Override
    public boolean get(int i) {
        return this.set.contains(i);
    }

    @Override
    public int maxSize() {
        return this.length;
    }

    @Override
    public int nextClearBit(int i) {
        for (int j = i; j < this.length; ++j) {
            if (this.set.contains(j)) continue;
            return j;
        }
        return -1;
    }

    @Override
    public int nextSetBit(int i) {
        return this.set.nextSetBit(i);
    }

    @Override
    public QRTTableStorage clone() throws CloneNotSupportedException {
        SparseIntSet copy = new SparseIntSet();
        copy.addAll(this.set);
        return new SparseSetStorage(copy, this.length);
    }

    public boolean equals(Object o) {
        if (!(o instanceof QRTTableStorage)) {
            return false;
        }
        QRTTableStorage bf = (QRTTableStorage)o;
        if (bf.maxSize() != this.maxSize()) {
            return false;
        }
        if (o instanceof SparseSetStorage) {
            SparseSetStorage sss = (SparseSetStorage)o;
            return this.set.containsAll(sss.set) && this.set.size() == sss.set.size();
        }
        if (bf.cardinality() != this.cardinality()) {
            return false;
        }
        Iterator it = bf.iterator();
        for (int i : this) {
            if (i == (Integer)it.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.set.iterator();
    }

    public String toString() {
        return "SparseSetStorage: " + this.set;
    }
}

