/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.routing.RouteTableMessage;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.util.ByteUtils;

public class ResetTableMessage
extends RouteTableMessage {
    private int tableSize;
    private byte infinity;

    public ResetTableMessage(int tableSize, byte infinity) {
        super((byte)1, 6, (byte)0);
        if (tableSize < 1 || infinity < 1) {
            throw new IllegalArgumentException("Argument too small: " + tableSize + ", " + infinity);
        }
        this.tableSize = tableSize;
        this.infinity = infinity;
    }

    @Override
    protected void writePayloadData(OutputStream out) throws IOException {
        byte[] buf = new byte[5];
        ByteUtils.int2leb(this.tableSize, buf, 0);
        buf[4] = this.infinity;
        out.write(buf);
    }

    protected ResetTableMessage(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) {
        super(guid, ttl, hops, payload.length, (byte)0, network);
        this.tableSize = ByteUtils.leb2int(payload, 1);
        this.infinity = payload[5];
    }

    public byte getInfinity() {
        return this.infinity;
    }

    public int getTableSize() {
        return this.tableSize;
    }

    @Override
    public String toString() {
        return "{RESET, tableSize: " + this.getTableSize() + ", Infinity: " + this.getInfinity() + "}";
    }
}

