/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.IntervalSet;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GGEP;
import org.limewire.io.GUID;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.util.Decorator;
import org.limewire.util.StringUtils;

public class HeadPongImpl
extends AbstractVendorMessage
implements HeadPong {
    private IntervalSet _ranges;
    private Set<IpPort> _altLocs = Collections.emptySet();
    private Set<PushEndpoint> _pushLocs = Collections.emptySet();
    private int _queueStatus;
    private boolean _fileFound;
    private boolean _completeFile;
    private byte[] _vendorId;
    private boolean _isFirewalled;
    private boolean _isDownloading;
    private boolean _tlsCapable;
    private boolean _routingBroken;
    private final PushEndpointFactory pushEndpointFactory;

    HeadPongImpl(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network, PushEndpointFactory pushEndpointFactory) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 24, version, payload, network);
        this.pushEndpointFactory = pushEndpointFactory;
        if (payload == null || payload.length < 2) {
            throw new BadPacketException("bad payload");
        }
        if (version == 1) {
            this.setFieldsFromBinary(payload);
        } else if (version >= 2) {
            this.setFieldsFromGGEP(payload);
        } else {
            throw new BadPacketException("invalid version!");
        }
    }

    protected HeadPongImpl(GUID guid, int version, byte[] payload) {
        super(F_LIME_VENDOR_ID, 24, version, payload);
        this.setGUID(guid);
        this.pushEndpointFactory = null;
    }

    public Class<HeadPong> getHandlerClass() {
        return HeadPong.class;
    }

    private void setFieldsFromBinary(byte[] payload) throws BadPacketException {
        if (payload[1] > 15) {
            throw new BadPacketException("invalid payload!");
        }
        try {
            DataInputStream dais = new DataInputStream(new ByteArrayInputStream(payload));
            byte features = (byte)(dais.readByte() & 0x1F);
            this._routingBroken = (features & 0x10) == 16;
            byte code = dais.readByte();
            if (!this.setFieldsFromCode(code)) {
                return;
            }
            this._vendorId = new byte[4];
            dais.readFully(this._vendorId);
            this._queueStatus = dais.readByte();
            if (!this._completeFile && (features & 1) == 1) {
                this._ranges = this.readRanges(dais);
            }
            if ((features & 4) == 4) {
                this._pushLocs = this.readPushLocs(dais);
            }
            if ((features & 2) == 2) {
                this._altLocs = this.readLocs(dais);
            }
        }
        catch (IOException oops) {
            throw new BadPacketException(oops);
        }
    }

    private void setFieldsFromGGEP(byte[] payload) throws BadPacketException {
        GGEP ggep;
        try {
            ggep = new GGEP(payload, 0);
        }
        catch (BadGGEPBlockException e) {
            throw new BadPacketException(e);
        }
        byte[] code = this.getRequiredGGEPField(ggep, "C");
        if (!this.setFieldsFromCode(code[0])) {
            return;
        }
        this._routingBroken = false;
        this._vendorId = this.getRequiredGGEPField(ggep, "V");
        this._queueStatus = this.getRequiredGGEPField(ggep, "Q")[0];
        byte[] features = this.getOptionalGGEPField(ggep, "F");
        if (features.length > 0) {
            this._tlsCapable = (features[0] & 1) == 1;
        }
        try {
            byte[] altLocs;
            byte[] pushLocs;
            byte[] ranges = this.getOptionalGGEPField(ggep, "R");
            byte[] ranges5 = this.getOptionalGGEPField(ggep, "R5");
            if (ranges.length > 0 || ranges5.length > 0) {
                this._ranges = this.parseRanges(ranges, ranges5);
            }
            if ((pushLocs = this.getOptionalGGEPField(ggep, "P")).length > 0) {
                this._pushLocs = this.parsePushLocs(pushLocs);
            }
            byte[] altTLS = this.getOptionalGGEPField(ggep, "T");
            BitNumbers tls = null;
            if (altTLS.length > 0) {
                tls = new BitNumbers(altTLS);
            }
            if ((altLocs = this.getOptionalGGEPField(ggep, "A")).length > 0) {
                this._altLocs = this.parseAltLocs(altLocs, tls);
            }
        }
        catch (IOException iox) {
            throw new BadPacketException(iox);
        }
    }

    private boolean setFieldsFromCode(byte code) {
        if (code == 0) {
            return false;
        }
        this._fileFound = true;
        if ((code & 4) == 4) {
            this._isFirewalled = true;
        }
        if ((code & 1) == 1) {
            this._completeFile = true;
        } else if ((code & 8) == 8) {
            this._isDownloading = true;
        }
        return true;
    }

    private byte[] getRequiredGGEPField(GGEP ggep, String header) throws BadPacketException {
        try {
            byte[] bytes = ggep.getBytes(header);
            if (bytes.length == 0) {
                throw new BadPacketException("no data for header: " + header + "!");
            }
            return bytes;
        }
        catch (BadGGEPPropertyException bgpe) {
            throw new BadPacketException(bgpe);
        }
    }

    private byte[] getOptionalGGEPField(GGEP ggep, String header) {
        if (ggep.hasValueFor(header)) {
            try {
                return ggep.getBytes(header);
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        return DataUtils.EMPTY_BYTE_ARRAY;
    }

    @Override
    public boolean hasFile() {
        return this._fileFound;
    }

    @Override
    public boolean hasCompleteFile() {
        return this.hasFile() && this._completeFile;
    }

    @Override
    public IntervalSet getRanges() {
        return this._ranges;
    }

    @Override
    public Set<IpPort> getAltLocs() {
        return this._altLocs;
    }

    @Override
    public Set<PushEndpoint> getPushLocs() {
        return this._pushLocs;
    }

    @Override
    public boolean isTLSCapable() {
        return this._tlsCapable;
    }

    @Override
    public Set<RemoteFileDesc> getAllLocsRFD(RemoteFileDesc original, RemoteFileDescFactory remoteFileDescFactory) {
        HashSet<RemoteFileDesc> ret = new HashSet<RemoteFileDesc>();
        for (IpPort ipPort : this._altLocs) {
            ret.add(remoteFileDescFactory.createRemoteFileDesc(original, ipPort));
        }
        for (PushEndpoint pushEndpoint : this._pushLocs) {
            ret.add(remoteFileDescFactory.createRemoteFileDesc(original, pushEndpoint));
        }
        return ret;
    }

    @Override
    public String getVendor() {
        if (this._vendorId != null) {
            return StringUtils.getASCIIString(this._vendorId);
        }
        return null;
    }

    @Override
    public boolean isFirewalled() {
        return this._isFirewalled;
    }

    @Override
    public int getQueueStatus() {
        return this._queueStatus;
    }

    @Override
    public boolean isBusy() {
        return this._queueStatus >= 127;
    }

    @Override
    public boolean isDownloading() {
        return this._isDownloading;
    }

    @Override
    public boolean isRoutingBroken() {
        return this._routingBroken;
    }

    @Override
    public String toString() {
        return "HeadPong:  isRoutingBroken: " + this.isRoutingBroken() + ", hasFile: " + this.hasFile() + ", hasCompleteFile: " + this.hasCompleteFile() + ", isDownloading: " + this.isDownloading() + ", isFirewalled: " + this.isFirewalled() + ", queue rank: " + this.getQueueStatus() + ", \nranges: " + this.getRanges() + ", \nalts: " + this.getAltLocs() + ", \npushalts: " + this.getPushLocs();
    }

    private final IntervalSet readRanges(DataInputStream dais) throws IOException {
        int rangeLength = dais.readUnsignedShort();
        byte[] ranges = new byte[rangeLength];
        dais.readFully(ranges);
        return this.parseRanges(ranges, DataUtils.EMPTY_BYTE_ARRAY);
    }

    private IntervalSet parseRanges(byte[] ranges, byte[] ranges5) throws IOException {
        return IntervalSet.parseBytes(ranges, ranges5);
    }

    private final Set<PushEndpoint> readPushLocs(DataInputStream dais) throws IOException, BadPacketException {
        int size = dais.readUnsignedShort();
        byte[] altlocs = new byte[size];
        dais.readFully(altlocs);
        return this.parsePushLocs(altlocs);
    }

    private Set<PushEndpoint> parsePushLocs(byte[] altlocs) throws IOException, BadPacketException {
        HashSet<PushEndpoint> ret = new HashSet<PushEndpoint>();
        ret.addAll(this.unpackPushEPs(new ByteArrayInputStream(altlocs)));
        return ret;
    }

    private List<PushEndpoint> unpackPushEPs(InputStream is) throws BadPacketException, IOException {
        LinkedList<PushEndpoint> ret = new LinkedList<PushEndpoint>();
        DataInputStream dais = new DataInputStream(is);
        while (dais.available() > 0) {
            ret.add(this.pushEndpointFactory.createFromBytes(dais));
        }
        return Collections.unmodifiableList(ret);
    }

    private final Set<IpPort> readLocs(DataInputStream dais) throws IOException, BadPacketException {
        int size = dais.readUnsignedShort();
        byte[] altlocs = new byte[size];
        dais.readFully(altlocs);
        return this.parseAltLocs(altlocs, null);
    }

    private Set<IpPort> parseAltLocs(byte[] altlocs, final BitNumbers tlsIdx) throws IOException, BadPacketException {
        HashSet<IpPort> ret = new HashSet<IpPort>();
        try {
            if (tlsIdx == null) {
                ret.addAll(NetworkUtils.unpackIps(altlocs));
            } else {
                ret.addAll(NetworkUtils.unpackIps(altlocs, (Decorator<IpPort, ? extends IpPort>)new Decorator<IpPort, IpPort>(){
                    int i = 0;

                    @Override
                    public IpPort decorate(IpPort input) {
                        if (tlsIdx.isSet(this.i)) {
                            input = new ConnectableImpl(input, true);
                        }
                        ++this.i;
                        return input;
                    }
                }));
            }
        }
        catch (InvalidDataException ide) {
            throw new BadPacketException(ide);
        }
        return ret;
    }

    @Override
    public byte[] getPayload() {
        return super.getPayload();
    }
}

