/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;
import org.limewire.core.settings.FilterSettings;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

@Singleton
public class RepetitiveQueryFilter
implements SpamFilter {
    private static final Log LOG = LogFactory.getLog(RepetitiveQueryFilter.class);
    private final String[] recentQueries;
    private final byte[] recentTTLs;
    private int roundRobin = 0;
    @InspectablePrimitive(value="repetitive queries")
    private long dropped = 0L;
    private final ConnectionManager connectionManager;

    @Inject
    RepetitiveQueryFilter(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        int size = FilterSettings.REPETITIVE_QUERY_FILTER_SIZE.getValue();
        this.recentQueries = new String[size];
        this.recentTTLs = new byte[size];
    }

    @Override
    public boolean allow(Message m) {
        if (!(m instanceof QueryRequest)) {
            return true;
        }
        if (this.recentQueries.length == 0) {
            return true;
        }
        if (this.connectionManager.isShieldedLeaf()) {
            return true;
        }
        QueryRequest q = (QueryRequest)m;
        if (q.isBrowseHostQuery() || q.isWhatIsNewRequest()) {
            return true;
        }
        String query = q.getQuery();
        assert (query != null);
        if (query.equals("\\") && q.hasQueryUrns()) {
            return true;
        }
        byte ttl = q.getTTL();
        for (int i = 0; i < this.recentQueries.length; ++i) {
            if (!query.equals(this.recentQueries[i]) || ttl != this.recentTTLs[i]) continue;
            LOG.debugf("Repetitive query blocked: {0}, {1}", (Object)query, (Object)ttl);
            ++this.dropped;
            return false;
        }
        this.recentQueries[this.roundRobin] = query;
        this.recentTTLs[this.roundRobin] = ttl;
        this.roundRobin = (this.roundRobin + 1) % this.recentQueries.length;
        return true;
    }
}

