/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.limewire.collection.PatriciaTrie;
import org.limewire.collection.Trie;
import org.limewire.io.IP;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteUtils;

public class IPList {
    private static final IP NULL_IP = new IP("*.*.*.*");
    private Trie<IP, IP> ips = new PatriciaTrie<IP, IP>(new IPKeyAnalyzer());

    public synchronized boolean isEmpty() {
        return this.ips.isEmpty();
    }

    public synchronized int size() {
        return this.ips.size();
    }

    public boolean add(String ipStr) {
        IP ip;
        try {
            ip = new IP(ipStr);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        this.add(ip);
        return true;
    }

    public synchronized void add(IP ip) {
        if (ip.equals(NULL_IP)) {
            this.ips.clear();
            this.ips.put(ip, ip);
            return;
        }
        if (!NetworkUtils.isValidAddress(ip)) {
            return;
        }
        AddFilter filter = new AddFilter(ip);
        Map.Entry<IP, IP> entry = this.ips.select(ip, filter);
        if (entry != null) {
            if (!entry.getKey().contains(ip)) {
                for (IP obsolete : filter.getContained()) {
                    this.ips.remove(obsolete);
                }
                this.ips.put(ip, ip);
            }
        } else {
            this.ips.put(ip, ip);
        }
    }

    public synchronized boolean contains(IP lookup2) {
        IP ip = this.ips.select(lookup2);
        return ip != null && ip.contains(lookup2);
    }

    public synchronized boolean isValidFilter(boolean allowPrivateIPs, NetworkInstanceUtils networkInstanceUtils) {
        ValidFilter filter = new ValidFilter(allowPrivateIPs, networkInstanceUtils);
        this.ips.traverse(filter);
        return filter.isValid();
    }

    public int logMinDistanceTo(IP ip) {
        int distance = this.minDistanceTo(ip);
        int logDistance = 0;
        int testMask = -1;
        while ((distance & testMask) != 0) {
            testMask <<= 1;
            ++logDistance;
        }
        return logDistance;
    }

    public synchronized int minDistanceTo(IP lookup2) {
        if (lookup2.mask != -1) {
            throw new IllegalArgumentException("Expected single IP, not an IP range.");
        }
        IP ip = this.ips.select(lookup2);
        if (ip == null) {
            return Integer.MAX_VALUE;
        }
        return ip.getDistanceTo(lookup2);
    }

    private static class IPKeyAnalyzer
    implements PatriciaTrie.KeyAnalyzer<IP> {
        private static final int[] BITS = IPKeyAnalyzer.createIntBitMask(32);

        private IPKeyAnalyzer() {
        }

        private static final int[] createIntBitMask(int bitCount) {
            int[] bits = new int[bitCount];
            for (int i = 0; i < bitCount; ++i) {
                bits[i] = 1 << bitCount - i - 1;
            }
            return bits;
        }

        @Override
        public int length(IP key) {
            return 32;
        }

        @Override
        public boolean isBitSet(IP key, int keyLength, int bitIndex) {
            int maddr = key.addr & key.mask;
            return (maddr & BITS[bitIndex]) != 0;
        }

        @Override
        public int bitIndex(IP key, int keyOff, int keyLength, IP found, int foundOff, int foundKeyLength) {
            int maddr2;
            int maddr1 = key.addr & key.mask;
            int n = maddr2 = found != null ? found.addr & found.mask : 0;
            if (keyOff != 0 || foundOff != 0) {
                throw new IllegalArgumentException("offsets must be 0 for fixed-size keys");
            }
            int length = Math.max(keyLength, foundKeyLength);
            boolean allNull = true;
            for (int i = 0; i < length; ++i) {
                int a = maddr1 & BITS[i];
                int b = maddr2 & BITS[i];
                if (allNull && a != 0) {
                    allNull = false;
                }
                if (a == b) continue;
                return i;
            }
            if (allNull) {
                return -1;
            }
            return -2;
        }

        @Override
        public int compare(IP o1, IP o2) {
            int addr1 = o1.addr & o1.mask;
            int addr2 = o2.addr & o2.mask;
            if (addr1 > addr2) {
                return 1;
            }
            if (addr1 < addr2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int bitsPerElement() {
            return 1;
        }

        @Override
        public boolean isPrefix(IP prefix, int offset, int length, IP key) {
            int addr1 = prefix.addr & prefix.mask;
            int addr2 = key.addr & key.mask;
            addr1 <<= offset;
            int mask = 0;
            for (int i = 0; i < length; ++i) {
                mask |= 1 << i;
            }
            return (addr1 &= mask) == (addr2 &= mask);
        }
    }

    private static class AddFilter
    implements Trie.Cursor<IP, IP> {
        private final IP lookup;
        private List<IP> contained;

        AddFilter(IP lookup2) {
            this.lookup = lookup2;
        }

        public List<IP> getContained() {
            if (this.contained == null) {
                return Collections.emptyList();
            }
            return this.contained;
        }

        @Override
        public Trie.Cursor.SelectStatus select(Map.Entry<? extends IP, ? extends IP> entry) {
            IP compare = entry.getKey();
            if (compare.contains(this.lookup)) {
                return Trie.Cursor.SelectStatus.EXIT;
            }
            if (this.lookup.contains(compare)) {
                if (this.contained == null) {
                    this.contained = new ArrayList<IP>();
                }
                this.contained.add(compare);
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
            return Trie.Cursor.SelectStatus.EXIT;
        }
    }

    private static class ValidFilter
    implements Trie.Cursor<IP, IP> {
        private static final int INVALID_SPACE = 60882944;
        private static final long TOTAL_SPACE = (long)Math.pow(2.0, 32.0) - 60882944L;
        private static final float MAX_LIST_SPACE = 0.025f;
        private boolean isInvalid;
        private long counter;
        private final boolean allowPrivateIPs;
        private final NetworkInstanceUtils networkInstanceUtils;

        public boolean isValid() {
            return !this.isInvalid && (float)this.counter / (float)TOTAL_SPACE < 0.025f;
        }

        public ValidFilter(boolean allowPrivateIPs, NetworkInstanceUtils networkInstanceUtils) {
            this.allowPrivateIPs = allowPrivateIPs;
            this.networkInstanceUtils = networkInstanceUtils;
        }

        @Override
        public Trie.Cursor.SelectStatus select(Map.Entry<? extends IP, ? extends IP> entry) {
            IP key = entry.getKey();
            byte[] buf = new byte[4];
            ByteUtils.int2beb(key.addr, buf, 0);
            if (!this.allowPrivateIPs && this.networkInstanceUtils.isPrivateAddress(buf)) {
                this.isInvalid = true;
                return Trie.Cursor.SelectStatus.EXIT;
            }
            this.counter = (long)((double)this.counter + Math.pow(2.0, this.countBits(~key.mask)));
            return Trie.Cursor.SelectStatus.CONTINUE;
        }

        private int countBits(int x) {
            x = (x >>> 1 & 0x55555555) + (x & 0x55555555);
            x = (x >>> 2 & 0x33333333) + (x & 0x33333333);
            x = (x >>> 4 & 0xF0F0F0F) + (x & 0xF0F0F0F);
            x = (x >>> 8 & 0xFF00FF) + (x & 0xFF00FF);
            return (x >>> 16) + (x & 0xFFFF);
        }
    }
}

