/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.bittorrent.BTDownloader;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.limewire.core.api.Category;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.SharingSettings;
import org.limewire.io.InvalidDataException;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

public abstract class AbstractCoreDownloader
implements CoreDownloader {
    private volatile int inactivePriority;
    private Map<String, Attribute> attributes = new ConcurrentHashMap<String, Attribute>();
    private File saveFile;
    private String defaultFileName;
    private final SaveLocationManager saveLocationManager;
    private final CategoryManager categoryManager;

    protected AbstractCoreDownloader(SaveLocationManager saveLocationManager, CategoryManager categoryManager) {
        this.saveLocationManager = Objects.nonNull(saveLocationManager, "saveLocationManager");
        this.categoryManager = Objects.nonNull(categoryManager, "categoryManager");
    }

    @Override
    public void setInactivePriority(int priority) {
        this.inactivePriority = priority;
    }

    @Override
    public int getInactivePriority() {
        return this.inactivePriority;
    }

    @Override
    public Object setAttribute(String key, Object value, boolean serialize) {
        return this.attributes.put(key, new Attribute(serialize, value));
    }

    @Override
    public Object getAttribute(String key) {
        Attribute attr = this.attributes.get(key);
        if (attr != null) {
            return attr.getObject();
        }
        return null;
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public boolean conflictsSaveFile(File saveFile) {
        return this.getSaveFile().equals(saveFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSaveFile(File saveDirectory, String fileName, boolean overwrite) throws DownloadException {
        block20: {
            if (fileName == null) {
                fileName = this.getDefaultFileName();
            }
            Category category = null;
            if (fileName != null) {
                category = this.categoryManager.getCategoryForFilename(fileName);
            }
            if (saveDirectory == null) {
                saveDirectory = SharingSettings.getSaveDirectory(category);
            }
            if (!saveDirectory.exists()) {
                saveDirectory.mkdirs();
            }
            try {
                fileName = CommonUtils.convertFileName(saveDirectory, fileName);
            }
            catch (IOException ie) {
                if (!saveDirectory.isDirectory()) break block20;
                throw new DownloadException(DownloadException.ErrorCode.PATH_NAME_TOO_LONG, saveDirectory);
            }
        }
        if (!saveDirectory.isDirectory()) {
            if (saveDirectory.exists()) {
                throw new DownloadException(DownloadException.ErrorCode.NOT_A_DIRECTORY, saveDirectory);
            }
            throw new DownloadException(DownloadException.ErrorCode.DIRECTORY_DOES_NOT_EXIST, saveDirectory);
        }
        File candidateFile = new File(saveDirectory, fileName);
        try {
            if (!FileUtils.isReallyParent(saveDirectory, candidateFile)) {
                throw new DownloadException(DownloadException.ErrorCode.SECURITY_VIOLATION, candidateFile);
            }
        }
        catch (IOException e) {
            throw new DownloadException(DownloadException.ErrorCode.FILESYSTEM_ERROR, candidateFile);
        }
        if (!FileUtils.setWriteable(saveDirectory)) {
            throw new DownloadException(DownloadException.ErrorCode.DIRECTORY_NOT_WRITEABLE, saveDirectory);
        }
        if (candidateFile.exists()) {
            if (!candidateFile.isFile() && !(this instanceof BTDownloader)) {
                throw new DownloadException(DownloadException.ErrorCode.FILE_NOT_REGULAR, candidateFile);
            }
            if (!overwrite) {
                throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_EXISTS, candidateFile);
            }
        }
        if (this.saveLocationManager.isSaveLocationTaken(candidateFile)) {
            throw new DownloadException(DownloadException.ErrorCode.FILE_IS_ALREADY_DOWNLOADED_TO, candidateFile);
        }
        AbstractCoreDownloader abstractCoreDownloader = this;
        synchronized (abstractCoreDownloader) {
            if (!this.isRelocatable()) {
                throw new DownloadException(DownloadException.ErrorCode.FILE_ALREADY_SAVED, candidateFile);
            }
            this.saveFile = candidateFile;
        }
    }

    @Override
    public synchronized File getSaveFile() {
        if (this.saveFile == null) {
            return this.getDefaultSaveFile();
        }
        return this.saveFile;
    }

    protected abstract File getDefaultSaveFile();

    protected synchronized String getDefaultFileName() {
        assert (this.defaultFileName != null) : "no default filename initialized!";
        return CommonUtils.convertFileName(this.defaultFileName);
    }

    protected synchronized boolean hasDefaultFileName() {
        return this.defaultFileName != null;
    }

    protected synchronized void setDefaultFileName(String defaultFileName) {
        this.defaultFileName = defaultFileName;
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento memento) throws InvalidDataException {
        this.saveFile = memento.getSaveFile();
        this.setDefaultFileName(memento.getDefaultFileName());
        if (memento.getAttributes() != null) {
            for (Map.Entry<String, Object> entry : memento.getAttributes().entrySet()) {
                this.attributes.put(entry.getKey(), new Attribute(true, entry.getValue()));
            }
        }
    }

    @Override
    public final synchronized DownloadMemento toMemento() {
        DownloadMemento memento = this.createMemento();
        this.fillInMemento(memento);
        return memento;
    }

    protected abstract DownloadMemento createMemento();

    protected void fillInMemento(DownloadMemento memento) {
        memento.setDownloadType(this.getDownloadType());
        memento.setSaveFile(this.saveFile);
        memento.setDefaultFileName(this.defaultFileName);
        HashMap<String, Object> saveAttributes = new HashMap<String, Object>(this.attributes.size());
        for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
            if (!entry.getValue().isSerialize()) continue;
            saveAttributes.put(entry.getKey(), entry.getValue().getObject());
        }
        memento.setAttributes(saveAttributes);
    }

    @Override
    public boolean isMementoSupported() {
        return true;
    }

    private static class Attribute {
        private final boolean serialize;
        private final Object object;

        public Attribute(boolean serialize, Object object) {
            this.serialize = serialize;
            this.object = object;
        }

        public boolean isSerialize() {
            return this.serialize;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

