/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.DIMERecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.List;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.nio.statemachine.WriteState;

public class AsyncDimeWriter
extends WriteState {
    private final Iterator<DIMERecord> recordIt;
    private final ByteBufferOutputStream out;
    public boolean isFirstRecord = true;
    private long amountProcessed;
    private boolean flipped;

    public AsyncDimeWriter(List<DIMERecord> records) {
        this.recordIt = records.iterator();
        this.out = new ByteBufferOutputStream();
    }

    @Override
    protected boolean processWrite(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        boolean isLastRecord;
        if (this.writeRemaining(channel)) {
            return true;
        }
        boolean bl = isLastRecord = !this.recordIt.hasNext();
        while (!isLastRecord) {
            DIMERecord current = this.recordIt.next();
            if (this.isFirstRecord) {
                current.setFirstRecord(true);
                this.isFirstRecord = false;
            } else {
                current.setFirstRecord(false);
            }
            isLastRecord = !this.recordIt.hasNext();
            current.setLastRecord(isLastRecord);
            current.write(this.out);
            if (!this.writeRemaining(channel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getAmountProcessed() {
        return this.amountProcessed;
    }

    private boolean writeRemaining(WritableByteChannel channel) throws IOException {
        ByteBuffer buffer = this.out.getBuffer();
        if (this.flipped || buffer.position() > 0) {
            if (!this.flipped) {
                buffer.flip();
                this.flipped = true;
            }
            int written = channel.write(buffer);
            this.amountProcessed += (long)written;
            if (buffer.hasRemaining()) {
                return true;
            }
            this.flipped = false;
            buffer.clear();
        }
        return false;
    }
}

