/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.ClassfulNetworkCounter;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.ContactFactory;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.FixedSizeHashMap;

class PassiveLeafRouteTable
implements RouteTable {
    private static final long serialVersionUID = 2378400850935282184L;
    private final Bucket bucket;
    private final Contact localNode;

    public PassiveLeafRouteTable(Vendor vendor, Version version) {
        this.localNode = ContactFactory.createLocalContact(vendor, version, true);
        this.bucket = new BucketImpl(this, KademliaSettings.REPLICATION_PARAMETER.getValue());
    }

    @Override
    public synchronized void add(Contact node) {
        if (this.isLocalNode(node)) {
            return;
        }
        if (node.isFirewalled()) {
            return;
        }
        ClassfulNetworkCounter counter = this.bucket.getClassfulNetworkCounter();
        if (counter == null || counter.isOkayToAdd(node)) {
            this.bucket.addActiveContact(node);
        }
    }

    @Override
    public synchronized void addRouteTableListener(RouteTable.RouteTableListener l) {
    }

    @Override
    public synchronized void removeRouteTableListener(RouteTable.RouteTableListener l) {
    }

    @Override
    public synchronized void clear() {
        this.bucket.clear();
    }

    @Override
    public synchronized Contact get(KUID nodeId) {
        if (nodeId.equals(this.localNode.getNodeID())) {
            return this.localNode;
        }
        return this.bucket.get(nodeId);
    }

    @Override
    public synchronized Collection<Contact> getActiveContacts() {
        ArrayList<Contact> nodes = new ArrayList<Contact>(this.bucket.getActiveContacts());
        nodes.add(this.localNode);
        return nodes;
    }

    @Override
    public synchronized Bucket getBucket(KUID nodeId) {
        return this.bucket;
    }

    @Override
    public synchronized Collection<Bucket> getBuckets() {
        return Collections.singleton(this.bucket);
    }

    @Override
    public synchronized Collection<Contact> getCachedContacts() {
        return this.bucket.getCachedContacts();
    }

    @Override
    public synchronized Collection<Contact> getContacts() {
        return this.bucket.getActiveContacts();
    }

    @Override
    public synchronized Contact getLocalNode() {
        return this.localNode;
    }

    @Override
    public synchronized Collection<KUID> getRefreshIDs(boolean bootstrapping) {
        return Collections.emptySet();
    }

    @Override
    public synchronized void handleFailure(KUID nodeId, SocketAddress address) {
        this.bucket.remove(nodeId);
    }

    @Override
    public synchronized boolean isLocalNode(Contact node) {
        return this.localNode.equals(node);
    }

    @Override
    public synchronized void purge(long elapsedTimeSinceLastContact) {
    }

    @Override
    public synchronized void purge(RouteTable.PurgeMode first, RouteTable.PurgeMode ... rest) {
    }

    @Override
    public synchronized Collection<Contact> select(KUID nodeId, int count, RouteTable.SelectMode mode) {
        Collection<Contact> nodes = this.bucket.select(nodeId, count);
        if (nodes.size() >= count || mode == RouteTable.SelectMode.ALIVE) {
            return nodes;
        }
        nodes = new ArrayList<Contact>(nodes);
        nodes.add(this.localNode);
        return nodes;
    }

    @Override
    public synchronized Contact select(KUID nodeId) {
        Contact c = this.bucket.select(nodeId);
        if (c != null) {
            return c;
        }
        return this.localNode;
    }

    @Override
    public synchronized void setContactPinger(RouteTable.ContactPinger pinger) {
    }

    @Override
    public void setNotifier(DHTExecutorService e) {
    }

    @Override
    public synchronized int size() {
        return this.bucket.size() + 1;
    }

    public synchronized String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getLocalNode()).append("\n");
        buffer.append(this.bucket);
        return buffer.toString();
    }

    private static class BucketImpl
    implements Bucket {
        private static final long serialVersionUID = 7625655390844705296L;
        private final RouteTable routeTable;
        private final int k;
        private final Map<KUID, Contact> map;
        private final ClassfulNetworkCounter counter;

        public BucketImpl(RouteTable routeTable, int k) {
            this.routeTable = routeTable;
            this.k = k;
            this.counter = new ClassfulNetworkCounter(this);
            this.map = new FixedSizeHashMap<KUID, Contact>(k, 0.75f, true, k){
                private static final long serialVersionUID = 4026436727356877846L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<KUID, Contact> eldest) {
                    if (super.removeEldestEntry(eldest)) {
                        BucketImpl.this.getClassfulNetworkCounter().decrementAndGet(eldest.getValue());
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public ClassfulNetworkCounter getClassfulNetworkCounter() {
            return this.counter;
        }

        @Override
        public boolean isLocalNode(Contact node) {
            return this.routeTable.isLocalNode(node);
        }

        @Override
        public void addActiveContact(Contact node) {
            this.updateContact(node);
        }

        @Override
        public Contact updateContact(Contact node) {
            Contact existing = this.map.remove(node.getNodeID());
            if (existing != null) {
                this.getClassfulNetworkCounter().decrementAndGet(existing);
            }
            Contact previous = this.map.put(node.getNodeID(), node);
            assert (previous == null);
            this.getClassfulNetworkCounter().incrementAndGet(node);
            return existing;
        }

        @Override
        public Contact addCachedContact(Contact node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(KUID nodeId) {
            return this.map.containsKey(nodeId);
        }

        @Override
        public boolean containsActiveContact(KUID nodeId) {
            return this.contains(nodeId);
        }

        @Override
        public boolean containsCachedContact(KUID nodeId) {
            return false;
        }

        @Override
        public Contact get(KUID nodeId) {
            return this.map.get(nodeId);
        }

        @Override
        public Contact getActiveContact(KUID nodeId) {
            return this.get(nodeId);
        }

        @Override
        public Collection<Contact> getActiveContacts() {
            return new ArrayList<Contact>(this.map.values());
        }

        @Override
        public Collection<Contact> getCachedContacts() {
            return Collections.emptySet();
        }

        @Override
        public int getActiveSize() {
            return this.map.size();
        }

        @Override
        public int getCacheSize() {
            return this.getCachedContacts().size();
        }

        @Override
        public KUID getBucketID() {
            return KUID.MINIMUM;
        }

        @Override
        public Contact getCachedContact(KUID nodeId) {
            return null;
        }

        @Override
        public int getDepth() {
            return 0;
        }

        @Override
        public Contact getLeastRecentlySeenActiveContact() {
            Contact lrs = null;
            Iterator<Contact> i$ = this.map.values().iterator();
            while (i$.hasNext()) {
                Contact c;
                lrs = c = i$.next();
            }
            return lrs;
        }

        @Override
        public Contact getLeastRecentlySeenCachedContact() {
            return null;
        }

        @Override
        public Contact getMostRecentlySeenActiveContact() {
            Iterator<Contact> i$ = this.map.values().iterator();
            if (i$.hasNext()) {
                Contact c = i$.next();
                return c;
            }
            return null;
        }

        @Override
        public Contact getMostRecentlySeenCachedContact() {
            return null;
        }

        @Override
        public long getTimeStamp() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean isActiveFull() {
            return false;
        }

        @Override
        public int getMaxActiveSize() {
            return this.k;
        }

        @Override
        public boolean isCacheFull() {
            return false;
        }

        @Override
        public boolean isRefreshRequired() {
            return false;
        }

        @Override
        public boolean isTooDeep() {
            return false;
        }

        @Override
        public void purge() {
        }

        @Override
        public boolean remove(KUID nodeId) {
            Contact node = this.map.remove(nodeId);
            if (node != null) {
                this.getClassfulNetworkCounter().decrementAndGet(node);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeActiveContact(KUID nodeId) {
            return this.remove(nodeId);
        }

        @Override
        public boolean removeCachedContact(KUID nodeId) {
            return false;
        }

        @Override
        public Collection<Contact> select(KUID nodeId, int count) {
            Contact[] nodes = new Contact[Math.min(count, this.map.size())];
            int index = 0;
            for (Contact c : this.map.values()) {
                if (index >= nodes.length) break;
                nodes[index++] = c;
            }
            return Arrays.asList(nodes);
        }

        @Override
        public Contact select(KUID nodeId) {
            Iterator<Contact> i$ = this.map.values().iterator();
            if (i$.hasNext()) {
                Contact c = i$.next();
                return c;
            }
            return null;
        }

        @Override
        public int size() {
            return this.getActiveSize() + this.getCacheSize();
        }

        @Override
        public List<Bucket> split() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void touch() {
        }

        public String toString() {
            return CollectionUtils.toString(this.map.values());
        }

        @Override
        public boolean isInSmallestSubtree() {
            return false;
        }
    }
}

