/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.PriorityMessageQueue;
import com.limegroup.gnutella.connection.SimpleMessageQueue;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.util.HashMap;

public class CompositeQueue
implements MessageQueue {
    private MessageQueue[] _queues = new MessageQueue[9];
    private int _queued = 0;
    private int _priority = 0;
    private int _priorityHint = 0;
    private boolean _cycled = true;
    private int _dropped = 0;
    private static final int BIG_QUEUE_SIZE = 100;
    private static final int QUEUE_SIZE = 1;
    private static final int BIG_QUEUE_TIME = 10000;
    public static final int QUEUE_TIME = 5000;
    private static final int PRIORITIES = 9;
    private static final int PRIORITY_CONTROL = 0;
    private static final int PRIORITY_WATCHDOG = 1;
    private static final int PRIORITY_PUSH = 2;
    private static final int PRIORITY_QUERY_REPLY = 3;
    private static final int PRIORITY_QUERY = 4;
    private static final int PRIORITY_PING_REPLY = 5;
    private static final int PRIORITY_PING = 6;
    private static final int PRIORITY_OTHER = 7;
    private static final int PRIORITY_OUR_QUERY = 8;

    public CompositeQueue() {
        this(10000, 100, 5000, 1);
    }

    public CompositeQueue(int largeTime, int largeSize, int normalTime, int normalSize) {
        this._queues[0] = new SimpleMessageQueue(10, Integer.MAX_VALUE, largeSize, false);
        this._queues[1] = new SimpleMessageQueue(1, Integer.MAX_VALUE, largeSize, true);
        this._queues[2] = new PriorityMessageQueue(6, largeTime, largeSize);
        this._queues[3] = new PriorityMessageQueue(6, largeTime, largeSize);
        this._queues[4] = new PriorityMessageQueue(3, normalTime, largeSize);
        this._queues[5] = new PriorityMessageQueue(1, normalTime, normalSize);
        this._queues[6] = new PriorityMessageQueue(1, normalTime, normalSize);
        this._queues[8] = new PriorityMessageQueue(10, largeTime, largeSize);
        this._queues[7] = new SimpleMessageQueue(1, Integer.MAX_VALUE, largeSize, false);
    }

    @Override
    public void add(Message m) {
        int priority = this.calculatePriority(m);
        MessageQueue queue = this._queues[priority];
        queue.add(m);
        int dropped = queue.resetDropped();
        this._dropped += dropped;
        this._queued += 1 - dropped;
        this._priorityHint = priority;
    }

    private int calculatePriority(Message m) {
        if (m instanceof VendorMessage.ControlMessage) {
            return 0;
        }
        byte opcode = m.getFunc();
        switch (opcode) {
            case -128: {
                return ((QueryRequest)m).isOriginated() ? 8 : 4;
            }
            case -127: {
                return 3;
            }
            case 1: {
                return m.getHops() == 0 && m.getTTL() <= 2 ? 1 : 5;
            }
            case 0: {
                return m.getHops() == 0 && m.getTTL() == 1 ? 1 : 6;
            }
            case 64: {
                return 2;
            }
        }
        return 7;
    }

    @Override
    public Message removeNext() {
        if (this._cycled) {
            this._cycled = false;
            this._priority = this._priorityHint;
            this._queues[this._priority].resetCycle();
        }
        while (this._queued > 0) {
            MessageQueue queue = this._queues[this._priority];
            Message m = queue.removeNext();
            int dropped = queue.resetDropped();
            this._dropped += dropped;
            this._queued -= (m == null ? 0 : 1) + dropped;
            if (m != null) {
                return m;
            }
            this._priority = (this._priority + 1) % 9;
            this._queues[this._priority].resetCycle();
        }
        this._cycled = true;
        return null;
    }

    @Override
    public final int resetDropped() {
        int ret = this._dropped;
        this._dropped = 0;
        return ret;
    }

    @Override
    public int size() {
        return this._queued;
    }

    @Override
    public boolean isEmpty() {
        return this._queued == 0;
    }

    @Override
    public void resetCycle() {
    }

    @Override
    public Object getDroppedStats() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("ver", 1);
        for (int i = 0; i < this._queues.length; ++i) {
            MessageQueue mq = this._queues[i];
            if (mq == null) continue;
            ret.put(String.valueOf(i), mq.getDroppedStats());
        }
        return ret;
    }
}

