/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.auth.UrnValidator;
import com.limegroup.gnutella.auth.ValidationEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventMulticaster;
import org.limewire.listener.EventMulticasterImpl;

@Singleton
class UrnValidatorImpl
implements UrnValidator {
    private final ContentManager contentManager;
    private final EventMulticaster<ValidationEvent> validationMulticaster;
    private final Set<URN> requestingValidation;

    @Inject
    public UrnValidatorImpl(ContentManager contentManager) {
        this.contentManager = contentManager;
        this.validationMulticaster = new EventMulticasterImpl<ValidationEvent>();
        this.requestingValidation = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void addListener(EventListener<ValidationEvent> eventListener) {
        this.validationMulticaster.addListener(eventListener);
    }

    @Override
    public boolean isInvalid(URN urn) {
        ContentResponseData r = this.contentManager.getResponse(urn);
        return r != null && !r.isOK();
    }

    @Override
    public boolean isValid(URN urn) {
        return this.contentManager.isVerified(urn);
    }

    @Override
    public void validate(URN urn) {
        if (this.requestingValidation.add(urn)) {
            this.contentManager.request(urn, new ContentResponseObserver(){

                @Override
                public void handleResponse(URN urn, ContentResponseData r) {
                    UrnValidatorImpl.this.requestingValidation.remove(urn);
                    ValidationEvent.Type type = r == null ? ValidationEvent.Type.UNKNOWN : (r.isOK() ? ValidationEvent.Type.VALID : ValidationEvent.Type.INVALID);
                    UrnValidatorImpl.this.validationMulticaster.broadcast(new ValidationEvent(type, urn));
                }
            }, 5000L);
        }
    }
}

