/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Buffer;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.core.settings.SearchSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.GUID;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.security.AddressSecurityToken;
import org.limewire.util.Objects;

@EagerSingleton
public final class QueryUnicaster
implements Service {
    private static final Log LOG = LogFactory.getLog(QueryUnicaster.class);
    public static final int ITERATION_TIME = 100;
    public static final int MIN_ENDPOINTS = 25;
    public static final int MAX_ENDPOINTS = 30;
    public static final long ONE_HOUR = 3600000L;
    private final Thread _querier;
    private final Map<GUID, QueryBundle> _queries;
    private final Map<ReplyHandler, Set<GUID>> _querySets;
    private final LinkedList<GUESSEndpoint> _queryHosts;
    private final Map<GUESSEndpoint, QueryKeyBundle> _queryKeys;
    private final Buffer<GUESSEndpoint> _pingList;
    private final List<GUID> _qGuidsToRemove;
    private long _lastPingTime = 0L;
    private int _testUDPPingsSent = 0;
    private boolean _initialized = false;
    private final NetworkManager networkManager;
    private final QueryRequestFactory queryRequestFactory;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<UDPService> udpService;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public QueryUnicaster(NetworkManager networkManager, QueryRequestFactory queryRequestFactory, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<UDPService> udpService, PingRequestFactory pingRequestFactory) {
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.backgroundExecutor = backgroundExecutor;
        this.messageRouter = messageRouter;
        this.udpService = udpService;
        this.pingRequestFactory = pingRequestFactory;
        this._queries = new Hashtable<GUID, QueryBundle>();
        this._queryHosts = new LinkedList();
        this._queryKeys = new Hashtable<GUESSEndpoint, QueryKeyBundle>();
        this._pingList = new Buffer(25);
        this._querySets = new Hashtable<ReplyHandler, Set<GUID>>();
        this._qGuidsToRemove = new Vector<GUID>();
        this._querier = ThreadExecutor.newManagedThread(new Runnable(){

            @Override
            public void run() {
                QueryUnicaster.this.queryLoop();
            }
        });
        this._querier.setName("QueryUnicaster");
        this._querier.setDaemon(true);
    }

    int getQueryNumber() {
        return this._queries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GUESSEndpoint> getUnicastEndpoints() {
        ArrayList<GUESSEndpoint> retList = new ArrayList<GUESSEndpoint>();
        LinkedList<GUESSEndpoint> linkedList = this._queryHosts;
        synchronized (linkedList) {
            int size = this._queryHosts.size();
            if (size > 0) {
                int max = size > 10 ? 10 : size;
                for (int i = 0; i < max; ++i) {
                    retList.add(this._queryHosts.get(i));
                }
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUESSEndpoint getUnicastEndpoint() {
        LinkedList<GUESSEndpoint> linkedList = this._queryHosts;
        synchronized (linkedList) {
            if (this._queryHosts.isEmpty()) {
                return null;
            }
            return this._queryHosts.getFirst();
        }
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public synchronized void start() {
        if (!this._initialized) {
            this._querier.start();
            QueryKeyExpirer expirer = new QueryKeyExpirer();
            this.backgroundExecutor.scheduleWithFixedDelay(expirer, 0L, 10800000L, TimeUnit.MILLISECONDS);
            this._initialized = true;
        }
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Directed Querier");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryLoop() {
        while (true) {
            try {
                while (true) {
                    this.waitForQueries();
                    GUESSEndpoint toQuery = this.getUnicastHost();
                    if (!this._queryKeys.containsKey(toQuery)) {
                        PingRequest pr = this.pingRequestFactory.createQueryKeyRequest();
                        this.udpService.get().send(pr, toQuery.getInetAddress(), toQuery.getPort());
                        continue;
                    }
                    AddressSecurityToken addressSecurityToken = this._queryKeys.get((Object)toQuery)._queryKey;
                    this.purgeGuidsInternal();
                    boolean currentHostUsed = false;
                    Object object = this._queries;
                    synchronized (object) {
                        for (QueryBundle currQB : this._queries.values()) {
                            if (currQB._hostsQueried.size() > 1000) {
                                this._qGuidsToRemove.add(new GUID(currQB._qr.getGUID()));
                                continue;
                            }
                            if (currQB._hostsQueried.contains(toQuery)) continue;
                            InetAddress ip = toQuery.getInetAddress();
                            QueryRequest qrToSend = this.queryRequestFactory.createQueryKeyQuery(currQB._qr, addressSecurityToken);
                            this.udpService.get().send(qrToSend, ip, toQuery.getPort());
                            currentHostUsed = true;
                            currQB._hostsQueried.add(toQuery);
                        }
                    }
                    if (!currentHostUsed) {
                        this.addUnicastEndpoint(toQuery);
                    }
                    object = this._qGuidsToRemove;
                    synchronized (object) {
                        this.purgeGuidsInternal();
                        this._qGuidsToRemove.clear();
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeGuidsInternal() {
        List<GUID> list = this._qGuidsToRemove;
        synchronized (list) {
            for (GUID currGuid : this._qGuidsToRemove) {
                this._queries.remove(currGuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForQueries() throws InterruptedException {
        LOG.trace("Waiting for queries");
        Map<GUID, QueryBundle> map = this._queries;
        synchronized (map) {
            if (this._queries.isEmpty()) {
                this._queries.wait();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Got " + this._queries.size() + " queries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQuery(QueryRequest query, ReplyHandler reference) {
        LOG.trace("Adding query");
        boolean added = false;
        GUID guid = new GUID(query.getGUID());
        Map<Object, Object> map = this._queries;
        synchronized (map) {
            if (!this._queries.containsKey(guid)) {
                QueryBundle qb = new QueryBundle(query);
                this._queries.put(guid, qb);
                this._queries.notifyAll();
                added = true;
            }
        }
        if (reference == null) {
            return added;
        }
        map = this._querySets;
        synchronized (map) {
            Set<GUID> guids = this._querySets.get(reference);
            if (guids == null) {
                guids = new HashSet<GUID>();
                this._querySets.put(reference, guids);
            }
            guids.add(guid);
        }
        return added;
    }

    public void addUnicastEndpoint(InetAddress address, int port) {
        if (!SearchSettings.GUESS_ENABLED.getValue()) {
            return;
        }
        if (this.notMe(address, port) && NetworkUtils.isValidPort(port) && NetworkUtils.isValidAddress(address)) {
            GUESSEndpoint endpoint = new GUESSEndpoint(address, port);
            this.addUnicastEndpoint(endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnicastEndpoint(GUESSEndpoint endpoint) {
        LinkedList<GUESSEndpoint> linkedList = this._queryHosts;
        synchronized (linkedList) {
            if (this._queryHosts.size() == 30) {
                LOG.trace("Evicting old unicast host to make room");
                this._queryHosts.removeLast();
            }
            LOG.trace("Adding new unicast host");
            this._queryHosts.addFirst(endpoint);
            this._queryHosts.notify();
            if (!(!this.udpService.get().isListening() || this.networkManager.isGUESSCapable() || this._testUDPPingsSent >= 10 || ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && NetworkUtils.isCloseIP(this.networkManager.getAddress(), endpoint.getInetAddress().getAddress()))) {
                LOG.info("Sending a UDP test ping");
                byte[] guid = this.udpService.get().getSolicitedGUID().bytes();
                PingRequest pr = this.pingRequestFactory.createPingRequest(guid, (byte)1, (byte)0);
                this.udpService.get().send(pr, endpoint.getInetAddress(), endpoint.getPort());
                ++this._testUDPPingsSent;
            }
        }
    }

    private boolean notMe(InetAddress address, int port) {
        return port != this.networkManager.getPort() || !Arrays.equals(address.getAddress(), this.networkManager.getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeQuery(ReplyHandler reference) {
        LOG.trace("Purging query by ReplyHandler");
        if (reference == null) {
            return;
        }
        Map<ReplyHandler, Set<GUID>> map = this._querySets;
        synchronized (map) {
            Set<GUID> guids = this._querySets.remove(reference);
            if (guids == null) {
                return;
            }
            for (GUID guid : guids) {
                this.purgeQuery(guid);
            }
        }
    }

    void purgeQuery(GUID queryGUID) {
        LOG.trace("Purging query by GUID");
        this._qGuidsToRemove.add(queryGUID);
    }

    public void handleQueryReply(QueryReply qr) {
        this.addResults(new GUID(qr.getGUID()), qr.getResultCount());
    }

    public void handleQueryKeyPong(PingReply pr) {
        Objects.nonNull(pr, "pong");
        AddressSecurityToken qk = pr.getQueryKey();
        Objects.nonNull(qk, "query key");
        InetAddress address = pr.getInetAddress();
        int port = pr.getPort();
        GUESSEndpoint endpoint = new GUESSEndpoint(address, port);
        this._queryKeys.put(endpoint, new QueryKeyBundle(qk));
        this.addUnicastEndpoint(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResults(GUID queryGUID, int numResultsToAdd) {
        LOG.trace("Adding results to query");
        Map<GUID, QueryBundle> map = this._queries;
        synchronized (map) {
            QueryBundle qb = this._queries.get(queryGUID);
            if (qb != null) {
                qb._numResults += numResultsToAdd;
                if (qb._numResults > 250) {
                    LOG.trace("Query has enough results, removing");
                    List<GUID> list = this._qGuidsToRemove;
                    synchronized (list) {
                        this._qGuidsToRemove.add(new GUID(qb._qr.getGUID()));
                        this.purgeGuidsInternal();
                        this._qGuidsToRemove.clear();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GUESSEndpoint getUnicastHost() throws InterruptedException {
        PingRequest pr;
        LOG.trace("Waiting for hosts");
        LinkedList<GUESSEndpoint> linkedList = this._queryHosts;
        synchronized (linkedList) {
            while (this._queryHosts.isEmpty()) {
                if (System.currentTimeMillis() - this._lastPingTime > 20000L) {
                    byte ttl = ConnectionSettings.TTL.getValue();
                    pr = this.pingRequestFactory.createPingRequest(ttl);
                    LOG.info("Broadcasting a ping");
                    this.messageRouter.get().broadcastPingRequest(pr);
                    this._lastPingTime = System.currentTimeMillis();
                }
                this._queryHosts.wait();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Got " + this._queryHosts.size() + " hosts");
        }
        if (this._queryHosts.size() < 25) {
            GUESSEndpoint toReturn = this._queryHosts.removeLast();
            Buffer<GUESSEndpoint> buffer = this._pingList;
            synchronized (buffer) {
                if (!this._pingList.contains(toReturn)) {
                    LOG.trace("Pinging unicast host before removing");
                    pr = this.pingRequestFactory.createPingRequest((byte)1);
                    InetAddress ip = toReturn.getInetAddress();
                    this.udpService.get().send(pr, ip, toReturn.getPort());
                    this._pingList.add(toReturn);
                }
            }
            return toReturn;
        }
        return this._queryHosts.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetUnicastEndpointsAndQueries() {
        LOG.trace("Resetting unicast hosts and queries");
        Object object = this._queries;
        synchronized (object) {
            this._queries.clear();
            this._queries.notifyAll();
        }
        object = this._queryHosts;
        synchronized (object) {
            this._queryHosts.clear();
            this._queryHosts.notifyAll();
        }
        object = this._queryKeys;
        synchronized (object) {
            this._queryKeys.clear();
            this._queryKeys.notifyAll();
        }
        object = this._pingList;
        synchronized (object) {
            this._pingList.clear();
            this._pingList.notifyAll();
        }
        this._lastPingTime = 0L;
        this._testUDPPingsSent = 0;
    }

    private class QueryKeyExpirer
    implements Runnable {
        private QueryKeyExpirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = QueryUnicaster.this._queryKeys;
            synchronized (map) {
                Iterator iter = QueryUnicaster.this._queryKeys.values().iterator();
                while (iter.hasNext()) {
                    if (!((QueryKeyBundle)iter.next()).shouldExpire()) continue;
                    iter.remove();
                }
            }
        }
    }

    private static class QueryKeyBundle {
        public static final long QUERY_KEY_LIFETIME = 0x6DDD00L;
        final long _birthTime;
        final AddressSecurityToken _queryKey;

        public QueryKeyBundle(AddressSecurityToken qk) {
            this._queryKey = qk;
            this._birthTime = System.currentTimeMillis();
        }

        public boolean shouldExpire() {
            return System.currentTimeMillis() - this._birthTime >= 0x6DDD00L;
        }

        public String toString() {
            return "{QueryKeyBundle: " + this._queryKey + " BirthTime = " + this._birthTime;
        }
    }

    private static class QueryBundle {
        public static final int MAX_RESULTS = 250;
        public static final int MAX_QUERIES = 1000;
        final QueryRequest _qr;
        int _numResults = 0;
        final Set<GUESSEndpoint> _hostsQueried = new HashSet<GUESSEndpoint>();

        public QueryBundle(QueryRequest qr) {
            this._qr = qr;
        }

        public String toString() {
            return "QueryBundle: " + this._qr;
        }
    }
}

