/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.LifecycleManager;
import com.limegroup.gnutella.LimeWireCoreModule;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Set;
import java.util.Vector;
import org.limewire.bittorrent.Torrent;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.inject.GuiceUtils;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.net.SocketsManager;

public class Main {
    @Inject
    private LifecycleManager lifecycleManager;
    @Inject
    private NetworkManager networkManager;
    @Inject
    private ConnectionServices connectionServices;
    @Inject
    private SearchServices searchServices;

    public static void main(String[] args) {
        Injector injector = Guice.createInjector(Stage.DEVELOPMENT, new LimeWireCoreModule(MainCallback.class));
        GuiceUtils.loadEagerSingletons(injector);
        Main main = injector.getInstance(Main.class);
        main.start();
    }

    private void start() {
        this.lifecycleManager.start();
        System.out.println("For a command list type help.");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("LimeRouter> ");
            try {
                String command = in.readLine();
                if (command == null) break;
                if (command.equals("help")) {
                    System.out.println("catcher                  Print host catcher.");
                    System.out.println("connect <host> [<port>]  Connect to a host[:port].");
                    System.out.println("help                     Print this message.");
                    System.out.println("listen <port>            Set the port you are listening on.");
                    System.out.println("query <string>           Send a query to the network.");
                    System.out.println("quit                     Quit the application.");
                    System.out.println("update                   Send pings to update the statistics.");
                } else if (command.equals("quit")) break;
                String[] commands = Main.split(command);
                if (commands.length >= 2 && commands[0].equals("connect")) {
                    try {
                        int port = 6346;
                        if (commands.length >= 3) {
                            port = Integer.parseInt(commands[2]);
                        }
                        System.out.println("Connecting...");
                        this.connectionServices.connectToHostAsynchronously(commands[1], port, SocketsManager.ConnectType.PLAIN);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Please specify a valid port.");
                    }
                    continue;
                }
                if (commands.length >= 2 && commands[0].equals("query")) {
                    int i = command.indexOf(32);
                    assert (i != -1 && i < command.length());
                    String query = command.substring(i + 1);
                    this.searchServices.query(this.searchServices.newQueryGUID(), query);
                    continue;
                }
                if (commands.length != 2 || !commands[0].equals("listen")) continue;
                try {
                    int port = Integer.parseInt(commands[1]);
                    this.networkManager.setListeningPort(port);
                }
                catch (NumberFormatException e) {
                    System.out.println("Please specify a valid port.");
                }
                catch (IOException e) {
                    System.out.println("Couldn't change port.  Try another value.");
                }
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
        System.out.println("Good bye.");
        this.lifecycleManager.shutdown();
    }

    public static String[] split(String s) {
        int n = (s = s.trim()).length();
        if (n == 0) {
            return new String[0];
        }
        Vector<String> buf = new Vector<String>();
        int i = 0;
        while (i < n) {
            assert (s.charAt(i) != ' ');
            int j = s.indexOf(32, i + 1);
            if (j == -1) {
                j = n;
            }
            buf.add(s.substring(i, j));
            i = j + 1;
            while (j < n && s.charAt(i) == ' ') {
                ++i;
            }
        }
        String[] ret = new String[buf.size()];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = (String)buf.get(i2);
        }
        return ret;
    }

    @Singleton
    private static class MainCallback
    implements ActivityCallback {
        private MainCallback() {
        }

        @Override
        public void handleQuery(QueryRequest query, String address, int port) {
        }

        @Override
        public void addDownload(Downloader mgr) {
        }

        @Override
        public void removeDownload(Downloader mgr) {
        }

        @Override
        public void addUpload(Uploader mgr) {
        }

        @Override
        public void uploadComplete(Uploader mgr) {
        }

        @Override
        public void handleSharedFileUpdate(File file) {
        }

        @Override
        public void downloadsComplete() {
        }

        @Override
        public void uploadsComplete() {
        }

        @Override
        public void promptAboutUnscannedPreview(Downloader dloader) {
            dloader.discardUnscannedPreview(false);
        }

        @Override
        public void restoreApplication() {
        }

        @Override
        public boolean isQueryAlive(GUID guid) {
            return false;
        }

        @Override
        public void handleMagnets(MagnetOptions[] magnets) {
        }

        @Override
        public void handleTorrent(File torrentFile) {
        }

        @Override
        public void installationCorrupted() {
        }

        @Override
        public String translate(String s) {
            return s;
        }

        @Override
        public void handleDownloadException(DownloadAction downLoadAction, DownloadException e, boolean supportsNewSaveDir) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleQueryResult(RemoteFileDesc rfd, QueryReply queryReply, Set<? extends IpPort> locs) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println("Query hit from " + rfd.getAddress() + ":");
                System.out.println("   " + rfd.getFileName());
            }
        }

        @Override
        public boolean promptTorrentFilePriorities(Torrent torrent) {
            return true;
        }

        @Override
        public boolean promptAboutTorrentWithBannedExtensions(Torrent torrent, Set<String> bannedExtensions) {
            return true;
        }
    }
}

