/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.BandwidthManager;
import com.limegroup.gnutella.UploadServices;
import java.net.Socket;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.nio.NBThrottle;
import org.limewire.nio.Throttle;
import org.limewire.rudp.RUDPSocket;

@Singleton
public class BandwidthManagerImpl
implements BandwidthManager {
    private final Throttle UP_TCP;
    private final Throttle DOWN_TCP;
    private final Throttle UP_UDP;
    private final UploadServices uploadServices;

    @Inject
    public BandwidthManagerImpl(UploadServices uploadServices) {
        this.uploadServices = uploadServices;
        this.UP_TCP = new NBThrottle(true, 0.0f);
        this.DOWN_TCP = new NBThrottle(false, 0.0f);
        this.UP_UDP = new NBThrottle(true, 0.0f);
    }

    @Override
    public void applyRate() {
        this.applyDownloadRate();
        this.applyUploadRate();
    }

    private void applyDownloadRate() {
        float downloadRate = DownloadSettings.MAX_DOWNLOAD_SPEED.getValue();
        if (!DownloadSettings.LIMIT_MAX_DOWNLOAD_SPEED.getValue()) {
            downloadRate = Float.MAX_VALUE;
        }
        this.DOWN_TCP.setRate(downloadRate);
    }

    @Override
    public void applyUploadRate() {
        float uploadRate = this.uploadServices.getRequestedUploadSpeed();
        this.UP_TCP.setRate(uploadRate);
        this.UP_UDP.setRate(uploadRate);
    }

    @Override
    public Throttle getReadThrottle() {
        this.applyDownloadRate();
        return this.DOWN_TCP;
    }

    @Override
    public Throttle getWriteThrottle() {
        this.applyUploadRate();
        return this.UP_TCP;
    }

    @Override
    public Throttle getWriteThrottle(Socket socket) {
        this.applyUploadRate();
        return socket instanceof RUDPSocket ? this.UP_UDP : this.UP_TCP;
    }
}

