/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.util.LimeWireUtils;
import org.limewire.activation.api.ActivationSettingsController;
import org.limewire.core.settings.ActivationSettings;

@Singleton
public class ActivationSettingsImpl
implements ActivationSettingsController {
    private static final String ACTIVATION_HOST = "https://activate.limewire.com/lookup";
    private static final String CACHE_KEY = "6E16C646C6968B8A4192A4E99630F412";
    private static final String SERV_PUB_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDGmaLDX44w4H95Dd11OOUBWIb9TAQfsqCz4JcLD1vTtiwY5t07FWnheoU2fe07pAODXc+t0Bh4AqdjZqQxVOSiKRcZsVs18tL3SDwnHsdgZ4D5ewvXzcbHloLeNB1JmIAKkg/EkO1H8T+7Qy4h1G1urlEblxsGJ5+nK2ftlCL34wIDAQAB";
    private final ApplicationServices applicationServices;

    @Inject
    public ActivationSettingsImpl(ApplicationServices applicationServices) {
        this.applicationServices = applicationServices;
    }

    @Override
    public String getActivationHost() {
        return ACTIVATION_HOST;
    }

    @Override
    public String getActivationKey() {
        return ActivationSettings.ACTIVATION_KEY.get();
    }

    @Override
    public String getModuleCode() {
        return ActivationSettings.MODULE_CODE.get();
    }

    @Override
    public String getPassKey() {
        return CACHE_KEY;
    }

    @Override
    public String getServerKey() {
        return SERV_PUB_KEY;
    }

    @Override
    public void setActivationKey(String key) {
        ActivationSettings.ACTIVATION_KEY.set(key);
    }

    @Override
    public boolean isLastStartPro() {
        return ActivationSettings.LAST_START_WAS_PRO.getValue();
    }

    @Override
    public boolean isNewInstall() {
        return this.applicationServices.isNewInstall();
    }

    @Override
    public void setLastStartPro(boolean value) {
        ActivationSettings.LAST_START_WAS_PRO.setValue(value);
        LimeWireUtils.setIsPro(value);
    }

    @Override
    public void setModuleCode(String mCode) {
        ActivationSettings.MODULE_CODE.set(mCode);
    }

    @Override
    public String getQueryString() {
        return LimeWireUtils.getLWInfoQueryString(this.applicationServices.getMyGUID(), ActivationSettings.LAST_START_WAS_PRO.getValue(), this.getModuleCode());
    }
}

